/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.vanilla;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IExtendableRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.ingredients.fluid.FluidIngredientHelper;
import mezz.jei.common.ingredients.fluid.FluidStackListFactory;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.plugins.vanilla.InventoryEffectRendererGuiHandler;
import mezz.jei.common.plugins.vanilla.RecipeBookGuiHandler;
import mezz.jei.common.plugins.vanilla.anvil.AnvilRecipeCategory;
import mezz.jei.common.plugins.vanilla.anvil.AnvilRecipeMaker;
import mezz.jei.common.plugins.vanilla.anvil.SmithingRecipeCategory;
import mezz.jei.common.plugins.vanilla.brewing.BrewingRecipeCategory;
import mezz.jei.common.plugins.vanilla.brewing.PotionSubtypeInterpreter;
import mezz.jei.common.plugins.vanilla.compostable.CompostableRecipeCategory;
import mezz.jei.common.plugins.vanilla.compostable.CompostingRecipeMaker;
import mezz.jei.common.plugins.vanilla.cooking.BlastingCategory;
import mezz.jei.common.plugins.vanilla.cooking.CampfireCookingCategory;
import mezz.jei.common.plugins.vanilla.cooking.FurnaceSmeltingCategory;
import mezz.jei.common.plugins.vanilla.cooking.SmokingCategory;
import mezz.jei.common.plugins.vanilla.cooking.fuel.FuelRecipeMaker;
import mezz.jei.common.plugins.vanilla.cooking.fuel.FurnaceFuelCategory;
import mezz.jei.common.plugins.vanilla.crafting.CraftingCategoryExtension;
import mezz.jei.common.plugins.vanilla.crafting.CraftingRecipeCategory;
import mezz.jei.common.plugins.vanilla.crafting.VanillaRecipes;
import mezz.jei.common.plugins.vanilla.crafting.replacers.ShulkerBoxColoringRecipeMaker;
import mezz.jei.common.plugins.vanilla.crafting.replacers.SuspiciousStewRecipeMaker;
import mezz.jei.common.plugins.vanilla.crafting.replacers.TippedArrowRecipeMaker;
import mezz.jei.common.plugins.vanilla.ingredients.item.ItemStackHelper;
import mezz.jei.common.plugins.vanilla.ingredients.item.ItemStackListFactory;
import mezz.jei.common.plugins.vanilla.stonecutting.StoneCuttingRecipeCategory;
import mezz.jei.common.render.FluidTankRenderer;
import mezz.jei.common.render.ItemStackRenderer;
import mezz.jei.common.transfer.PlayerRecipeTransferHandler;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.StackHelper;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.BlastFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.FurnaceScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.client.gui.screens.inventory.SmokerScreen;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.BlastFurnaceMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.FurnaceMenu;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.inventory.SmokerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.ShulkerBoxColoring;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.SuspiciousStewRecipe;
import net.minecraft.world.item.crafting.TippedArrowRecipe;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class VanillaPlugin
implements IModPlugin {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private CraftingRecipeCategory craftingCategory;
    @Nullable
    private IRecipeCategory<StonecutterRecipe> stonecuttingCategory;
    @Nullable
    private IRecipeCategory<SmeltingRecipe> furnaceCategory;
    @Nullable
    private IRecipeCategory<SmokingRecipe> smokingCategory;
    @Nullable
    private IRecipeCategory<BlastingRecipe> blastingCategory;
    @Nullable
    private IRecipeCategory<CampfireCookingRecipe> campfireCategory;
    @Nullable
    private IRecipeCategory<UpgradeRecipe> smithingCategory;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jei", "minecraft");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)Items.TIPPED_ARROW, (IIngredientSubtypeInterpreter)PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)Items.POTION, (IIngredientSubtypeInterpreter)PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)Items.SPLASH_POTION, (IIngredientSubtypeInterpreter)PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)Items.LINGERING_POTION, (IIngredientSubtypeInterpreter)PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)Items.ENCHANTED_BOOK, (itemStack, context) -> {
            ArrayList<CallSite> enchantmentNames = new ArrayList<CallSite>();
            ListTag enchantments = EnchantedBookItem.getEnchantments((ItemStack)itemStack);
            for (int i = 0; i < enchantments.size(); ++i) {
                Enchantment enchantment;
                CompoundTag compoundnbt = enchantments.getCompound(i);
                String id = compoundnbt.getString("id");
                IPlatformRegistry enchantmentRegistry = Services.PLATFORM.getRegistry(Registry.ENCHANTMENT_REGISTRY);
                ResourceLocation resourceLocation = ResourceLocation.tryParse((String)id);
                if (resourceLocation == null || (enchantment = (Enchantment)enchantmentRegistry.getValue(resourceLocation)) == null) continue;
                String enchantmentUid = enchantment.getDescriptionId() + ".lvl" + compoundnbt.getShort("lvl");
                enchantmentNames.add((CallSite)((Object)enchantmentUid));
            }
            enchantmentNames.sort(null);
            return ((Object)enchantmentNames).toString();
        });
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        ISubtypeManager subtypeManager = registration.getSubtypeManager();
        StackHelper stackHelper = new StackHelper(subtypeManager);
        List<ItemStack> itemStacks = ItemStackListFactory.create(stackHelper);
        ItemStackHelper itemStackHelper = new ItemStackHelper(stackHelper);
        ItemStackRenderer itemStackRenderer = new ItemStackRenderer();
        registration.register((IIngredientType)VanillaTypes.ITEM_STACK, itemStacks, (IIngredientHelper)itemStackHelper, (IIngredientRenderer)itemStackRenderer);
        IPlatformFluidHelperInternal<?> platformFluidHelper = Services.PLATFORM.getFluidHelper();
        this.registerFluidIngredients(registration, platformFluidHelper);
    }

    private <T> void registerFluidIngredients(IModIngredientRegistration registration, IPlatformFluidHelperInternal<T> platformFluidHelper) {
        ISubtypeManager subtypeManager = registration.getSubtypeManager();
        IColorHelper colorHelper = registration.getColorHelper();
        IPlatformRegistry<Fluid> registry = Services.PLATFORM.getRegistry(Registry.FLUID_REGISTRY);
        List<T> fluidIngredients = FluidStackListFactory.create(registry, platformFluidHelper);
        FluidIngredientHelper<T> fluidIngredientHelper = new FluidIngredientHelper<T>(subtypeManager, colorHelper, platformFluidHelper);
        FluidTankRenderer<T> fluidTankRenderer = new FluidTankRenderer<T>(platformFluidHelper);
        IIngredientTypeWithSubtypes fluidIngredientType = platformFluidHelper.getFluidIngredientType();
        registration.register((IIngredientType)fluidIngredientType, fluidIngredients, fluidIngredientHelper, fluidTankRenderer);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        Textures textures = Internal.getTextures();
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[11];
        this.craftingCategory = new CraftingRecipeCategory(guiHelper);
        iRecipeCategoryArray[0] = this.craftingCategory;
        this.stonecuttingCategory = new StoneCuttingRecipeCategory(guiHelper);
        iRecipeCategoryArray[1] = this.stonecuttingCategory;
        this.furnaceCategory = new FurnaceSmeltingCategory(guiHelper);
        iRecipeCategoryArray[2] = this.furnaceCategory;
        this.smokingCategory = new SmokingCategory(guiHelper);
        iRecipeCategoryArray[3] = this.smokingCategory;
        this.blastingCategory = new BlastingCategory(guiHelper);
        iRecipeCategoryArray[4] = this.blastingCategory;
        this.campfireCategory = new CampfireCookingCategory(guiHelper);
        iRecipeCategoryArray[5] = this.campfireCategory;
        this.smithingCategory = new SmithingRecipeCategory(guiHelper);
        iRecipeCategoryArray[6] = this.smithingCategory;
        iRecipeCategoryArray[7] = new CompostableRecipeCategory(guiHelper);
        iRecipeCategoryArray[8] = new FurnaceFuelCategory(guiHelper, textures);
        iRecipeCategoryArray[9] = new BrewingRecipeCategory(guiHelper);
        iRecipeCategoryArray[10] = new AnvilRecipeCategory(guiHelper);
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        IExtendableRecipeCategory craftingCategory = registration.getCraftingCategory();
        craftingCategory.addCategoryExtension(CraftingRecipe.class, r -> !r.isSpecial(), CraftingCategoryExtension::new);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ErrorUtil.checkNotNull(this.craftingCategory, "craftingCategory");
        ErrorUtil.checkNotNull(this.stonecuttingCategory, "stonecuttingCategory");
        ErrorUtil.checkNotNull(this.furnaceCategory, "furnaceCategory");
        ErrorUtil.checkNotNull(this.smokingCategory, "smokingCategory");
        ErrorUtil.checkNotNull(this.blastingCategory, "blastingCategory");
        ErrorUtil.checkNotNull(this.campfireCategory, "campfireCategory");
        ErrorUtil.checkNotNull(this.smithingCategory, "smithingCategory");
        IIngredientManager ingredientManager = registration.getIngredientManager();
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getVanillaRecipeFactory();
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IStackHelper stackHelper = jeiHelpers.getStackHelper();
        VanillaRecipes vanillaRecipes = new VanillaRecipes();
        Map<Boolean, List<CraftingRecipe>> craftingRecipes = vanillaRecipes.getCraftingRecipes((IRecipeCategory<CraftingRecipe>)this.craftingCategory);
        List<CraftingRecipe> handledCraftingRecipes = craftingRecipes.get(true);
        List<CraftingRecipe> unhandledCraftingRecipes = craftingRecipes.get(false);
        List<CraftingRecipe> specialCraftingRecipes = VanillaPlugin.replaceSpecialCraftingRecipes(unhandledCraftingRecipes, stackHelper);
        registration.addRecipes(RecipeTypes.CRAFTING, handledCraftingRecipes);
        registration.addRecipes(RecipeTypes.CRAFTING, specialCraftingRecipes);
        registration.addRecipes(RecipeTypes.STONECUTTING, vanillaRecipes.getStonecuttingRecipes(this.stonecuttingCategory));
        registration.addRecipes(RecipeTypes.SMELTING, vanillaRecipes.getFurnaceRecipes(this.furnaceCategory));
        registration.addRecipes(RecipeTypes.SMOKING, vanillaRecipes.getSmokingRecipes(this.smokingCategory));
        registration.addRecipes(RecipeTypes.BLASTING, vanillaRecipes.getBlastingRecipes(this.blastingCategory));
        registration.addRecipes(RecipeTypes.CAMPFIRE_COOKING, vanillaRecipes.getCampfireCookingRecipes(this.campfireCategory));
        registration.addRecipes(RecipeTypes.FUELING, FuelRecipeMaker.getFuelRecipes(ingredientManager));
        registration.addRecipes(RecipeTypes.ANVIL, AnvilRecipeMaker.getAnvilRecipes(vanillaRecipeFactory, ingredientManager));
        registration.addRecipes(RecipeTypes.SMITHING, vanillaRecipes.getSmithingRecipes(this.smithingCategory));
        registration.addRecipes(RecipeTypes.COMPOSTING, CompostingRecipeMaker.getRecipes(ingredientManager));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CraftingScreen.class, 88, 32, 28, 23, new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeClickArea(InventoryScreen.class, 137, 29, 10, 13, new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeClickArea(BrewingStandScreen.class, 97, 16, 14, 30, new RecipeType[]{RecipeTypes.BREWING});
        registration.addRecipeClickArea(FurnaceScreen.class, 78, 32, 28, 23, new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeClickArea(SmokerScreen.class, 78, 32, 28, 23, new RecipeType[]{RecipeTypes.SMOKING, RecipeTypes.FUELING});
        registration.addRecipeClickArea(BlastFurnaceScreen.class, 78, 32, 28, 23, new RecipeType[]{RecipeTypes.BLASTING, RecipeTypes.FUELING});
        registration.addRecipeClickArea(AnvilScreen.class, 102, 48, 22, 15, new RecipeType[]{RecipeTypes.ANVIL});
        registration.addRecipeClickArea(SmithingScreen.class, 102, 48, 22, 15, new RecipeType[]{RecipeTypes.SMITHING});
        registration.addGenericGuiContainerHandler(EffectRenderingInventoryScreen.class, new InventoryEffectRendererGuiHandler());
        registration.addGuiContainerHandler(CraftingScreen.class, new RecipeBookGuiHandler());
        registration.addGuiContainerHandler(InventoryScreen.class, new RecipeBookGuiHandler());
        registration.addGuiContainerHandler(AbstractFurnaceScreen.class, new RecipeBookGuiHandler());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CraftingMenu.class, RecipeTypes.CRAFTING, 1, 9, 10, 36);
        registration.addRecipeTransferHandler(FurnaceMenu.class, RecipeTypes.SMELTING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(FurnaceMenu.class, RecipeTypes.FUELING, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(SmokerMenu.class, RecipeTypes.SMOKING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(SmokerMenu.class, RecipeTypes.FUELING, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(BlastFurnaceMenu.class, RecipeTypes.BLASTING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(BlastFurnaceMenu.class, RecipeTypes.FUELING, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(BrewingStandMenu.class, RecipeTypes.BREWING, 0, 4, 5, 36);
        registration.addRecipeTransferHandler(AnvilMenu.class, RecipeTypes.ANVIL, 0, 2, 3, 36);
        registration.addRecipeTransferHandler(SmithingMenu.class, RecipeTypes.SMITHING, 0, 2, 3, 36);
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
        IStackHelper stackHelper = jeiHelpers.getStackHelper();
        IConnectionToServer serverConnection = Internal.getServerConnection();
        PlayerRecipeTransferHandler recipeTransferHandler = new PlayerRecipeTransferHandler(serverConnection, stackHelper, transferHelper);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)recipeTransferHandler, RecipeTypes.CRAFTING);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.CRAFTING_TABLE), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.STONECUTTER), new RecipeType[]{RecipeTypes.STONECUTTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.FURNACE), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.SMOKER), new RecipeType[]{RecipeTypes.SMOKING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.BLAST_FURNACE), new RecipeType[]{RecipeTypes.BLASTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.CAMPFIRE), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.SOUL_CAMPFIRE), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.BREWING_STAND), new RecipeType[]{RecipeTypes.BREWING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.ANVIL), new RecipeType[]{RecipeTypes.ANVIL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.SMITHING_TABLE), new RecipeType[]{RecipeTypes.SMITHING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.COMPOSTER), new RecipeType[]{RecipeTypes.COMPOSTING});
    }

    @Nullable
    public CraftingRecipeCategory getCraftingCategory() {
        return this.craftingCategory;
    }

    private static List<CraftingRecipe> replaceSpecialCraftingRecipes(List<CraftingRecipe> unhandledCraftingRecipes, IStackHelper stackHelper) {
        IdentityHashMap<Class<SuspiciousStewRecipe>, Supplier<List>> replacers = new IdentityHashMap<Class<SuspiciousStewRecipe>, Supplier<List>>();
        replacers.put(TippedArrowRecipe.class, () -> TippedArrowRecipeMaker.createRecipes(stackHelper));
        replacers.put(ShulkerBoxColoring.class, ShulkerBoxColoringRecipeMaker::createRecipes);
        replacers.put(SuspiciousStewRecipe.class, SuspiciousStewRecipeMaker::createRecipes);
        return unhandledCraftingRecipes.stream().map(Object::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                List results = (List)supplier.get();
                return results.stream();
            }
            catch (RuntimeException e) {
                LOGGER.error("Failed to create JEI recipes for {}", recipeClass, (Object)e);
                return Stream.of(new CraftingRecipe[0]);
            }
        }).toList();
    }
}

