/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ItemStackRenderer
implements IIngredientRenderer<ItemStack> {
    private static final Logger LOGGER = LogManager.getLogger();

    public void render(PoseStack poseStack, @Nullable ItemStack ingredient) {
        if (ingredient != null) {
            PoseStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.pushPose();
            modelViewStack.mulPoseMatrix(poseStack.last().pose());
            RenderSystem.enableDepthTest();
            Minecraft minecraft = Minecraft.getInstance();
            Font font = this.getFontRenderer(minecraft, ingredient);
            ItemRenderer itemRenderer = minecraft.getItemRenderer();
            itemRenderer.renderAndDecorateFakeItem(ingredient, 0, 0);
            itemRenderer.renderGuiItemDecorations(font, ingredient, 0, 0);
            RenderSystem.disableBlend();
            modelViewStack.popPose();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public void render(PoseStack stack, int xPosition, int yPosition, @Nullable ItemStack ingredient) {
        stack.pushPose();
        stack.translate((double)xPosition, (double)yPosition, 0.0);
        this.render(stack, ingredient);
        stack.popPose();
    }

    public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        try {
            return ingredient.getTooltipLines((Player)player, tooltipFlag);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(ingredient);
            LOGGER.error("Failed to get tooltip: {}", (Object)itemStackInfo, (Object)e);
            ArrayList<Component> list = new ArrayList<Component>();
            TranslatableComponent crash = new TranslatableComponent("jei.tooltip.error.crash");
            list.add((Component)crash.withStyle(ChatFormatting.RED));
            return list;
        }
    }

    public Font getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        return renderHelper.getFontRenderer(minecraft, ingredient);
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 16;
    }
}

