/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.load.registration;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.common.util.ErrorUtil;
import org.jetbrains.annotations.Unmodifiable;

public class RecipeCategoryRegistration
implements IRecipeCategoryRegistration {
    private final List<IRecipeCategory<?>> recipeCategories = new ArrayList();
    private final Set<RecipeType<?>> recipeTypes = new HashSet();
    private final IJeiHelpers jeiHelpers;

    public RecipeCategoryRegistration(IJeiHelpers jeiHelpers) {
        this.jeiHelpers = jeiHelpers;
    }

    public void addRecipeCategories(IRecipeCategory<?> ... recipeCategories) {
        ErrorUtil.checkNotEmpty(recipeCategories, "recipeCategories");
        for (IRecipeCategory<?> recipeCategory : recipeCategories) {
            RecipeType recipeType = recipeCategory.getRecipeType();
            Preconditions.checkNotNull((Object)recipeType, (String)"Recipe type cannot be null %s", recipeCategory);
            if (this.recipeTypes.contains(recipeType)) {
                throw new IllegalArgumentException("A RecipeCategory with type \"" + recipeType.getRecipeClass() + "\" has already been registered.");
            }
            this.recipeTypes.add(recipeType);
        }
        Collections.addAll(this.recipeCategories, recipeCategories);
    }

    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    public @Unmodifiable List<IRecipeCategory<?>> getRecipeCategories() {
        return List.copyOf(this.recipeCategories);
    }
}

