/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import mezz.jei.common.gui.HoverChecker;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.handlers.TextFieldInputHandler;
import mezz.jei.common.platform.IPlatformInputHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.core.util.TextHistory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.TextComponent;

public class GuiTextFieldFilter
extends EditBox {
    private static final int maxSearchLength = 128;
    private static final TextHistory history = new TextHistory();
    private final HoverChecker hoverChecker;
    private final DrawableNineSliceTexture background;
    private ImmutableRect2i backgroundBounds;
    private boolean previousKeyboardRepeatEnabled;

    public GuiTextFieldFilter(Textures textures) {
        super(Minecraft.getInstance().font, 0, 0, 0, 0, TextComponent.EMPTY);
        this.setMaxLength(128);
        this.hoverChecker = new HoverChecker();
        this.background = textures.getSearchBackground();
        this.backgroundBounds = ImmutableRect2i.EMPTY;
        this.setBordered(false);
    }

    public void updateBounds(ImmutableRect2i area) {
        this.backgroundBounds = area;
        this.x = area.getX() + 4;
        this.y = area.getY() + (area.getHeight() - 8) / 2;
        this.width = area.getWidth() - 12;
        this.height = area.getHeight();
        this.hoverChecker.updateBounds(area);
        this.setHighlightPos(this.getCursorPosition());
    }

    public void setValue(String filterText) {
        if (!filterText.equals(this.getValue())) {
            super.setValue(filterText);
        }
    }

    public Optional<String> getHistory(TextHistory.Direction direction) {
        String currentText = this.getValue();
        return history.get(direction, currentText);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public IUserInputHandler createInputHandler() {
        return new TextFieldInputHandler(this);
    }

    public void setFocused(boolean keyboardFocus) {
        boolean previousFocus = this.isFocused();
        super.setFocused(keyboardFocus);
        if (previousFocus != keyboardFocus) {
            Minecraft minecraft = Minecraft.getInstance();
            if (keyboardFocus) {
                IPlatformInputHelper inputHelper = Services.PLATFORM.getInputHelper();
                this.previousKeyboardRepeatEnabled = inputHelper.isSendRepeatsToGui(minecraft.keyboardHandler);
                minecraft.keyboardHandler.setSendRepeatsToGui(true);
            } else {
                minecraft.keyboardHandler.setSendRepeatsToGui(this.previousKeyboardRepeatEnabled);
            }
            String text = this.getValue();
            history.add(text);
        }
    }

    public void renderButton(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.background.draw(poseStack, this.backgroundBounds);
        }
        super.renderButton(poseStack, mouseX, mouseY, partialTicks);
    }
}

