/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnegative;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.phys.Vec2;

public final class MathUtil {
    private static final List<Rectangle2dCropper> rectangle2dCroppers = List.of(MathUtil::cropTop, MathUtil::cropBottom, MathUtil::cropLeft, MathUtil::cropRight);

    private MathUtil() {
    }

    public static int divideCeil(int numerator, int denominator) {
        return (int)Math.ceil((float)numerator / (float)denominator);
    }

    public static boolean intersects(Collection<ImmutableRect2i> areas, ImmutableRect2i comparisonArea) {
        for (ImmutableRect2i area : areas) {
            if (!MathUtil.intersects(area, comparisonArea)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersects(ImmutableRect2i rect1, ImmutableRect2i rect2) {
        if (rect1.isEmpty() || rect2.isEmpty()) {
            return false;
        }
        return rect2.getX() + rect2.getWidth() > rect1.getX() && rect2.getY() + rect2.getHeight() > rect1.getY() && rect2.getX() < rect1.getX() + rect1.getWidth() && rect2.getY() < rect1.getY() + rect1.getHeight();
    }

    public static ImmutableRect2i cropToAvoidIntersection(Collection<ImmutableRect2i> areas, ImmutableRect2i comparisonArea, int availableWidth, int availableHeight) {
        int maxWidth = Math.min(comparisonArea.getWidth(), availableWidth);
        int maxHeight = Math.min(comparisonArea.getHeight(), availableHeight);
        return areas.stream().filter(rectangle2d -> MathUtil.intersects(rectangle2d, comparisonArea)).sorted(Comparator.comparingInt(r -> MathUtil.contentArea(r, maxWidth, maxHeight))).reduce(comparisonArea, (r1, r2) -> MathUtil.bestCrop(r1, r2, maxWidth, maxHeight));
    }

    private static ImmutableRect2i bestCrop(ImmutableRect2i rect, ImmutableRect2i intersecting, int maxWidth, int maxHeight) {
        if (rect.isEmpty() || maxHeight == 0 || maxWidth == 0) {
            return rect;
        }
        return rectangle2dCroppers.stream().map(cropper -> cropper.crop(rect, intersecting)).max(Comparator.comparingInt(r -> MathUtil.contentArea(r, maxWidth, maxHeight))).orElse(ImmutableRect2i.EMPTY);
    }

    @Nonnegative
    public static int contentArea(ImmutableRect2i rect, int maxWidth, int maxHeight) {
        return Math.min(rect.getWidth(), maxWidth) * Math.min(rect.getHeight(), maxHeight);
    }

    private static ImmutableRect2i cropTop(ImmutableRect2i original, ImmutableRect2i intersecting) {
        int newY = intersecting.getY() + intersecting.getHeight();
        int cropTopAmount = newY - original.getY();
        if (cropTopAmount < 0) {
            return ImmutableRect2i.EMPTY;
        }
        return original.cropTop(cropTopAmount);
    }

    private static ImmutableRect2i cropLeft(ImmutableRect2i original, ImmutableRect2i intersecting) {
        int newX = intersecting.getX() + intersecting.getWidth();
        int cropLeftAmount = newX - original.getX();
        if (cropLeftAmount < 0) {
            return ImmutableRect2i.EMPTY;
        }
        return original.cropLeft(cropLeftAmount);
    }

    private static ImmutableRect2i cropBottom(ImmutableRect2i original, ImmutableRect2i intersecting) {
        int newHeight = intersecting.getY() - original.getY();
        if (newHeight < 0) {
            return ImmutableRect2i.EMPTY;
        }
        return original.keepTop(newHeight);
    }

    private static ImmutableRect2i cropRight(ImmutableRect2i original, ImmutableRect2i intersecting) {
        int newWidth = intersecting.getX() - original.getX();
        if (newWidth < 0) {
            return ImmutableRect2i.EMPTY;
        }
        return original.keepLeft(newWidth);
    }

    public static boolean contains(Collection<ImmutableRect2i> areas, double x, double y) {
        for (ImmutableRect2i guiArea : areas) {
            if (!guiArea.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Rect2i rect, double x, double y) {
        return x >= (double)rect.getX() && y >= (double)rect.getY() && x < (double)(rect.getX() + rect.getWidth()) && y < (double)(rect.getY() + rect.getHeight());
    }

    public static ImmutableRect2i union(ImmutableRect2i rect1, ImmutableRect2i rect2) {
        if (rect1.isEmpty()) {
            return rect2;
        }
        if (rect2.isEmpty()) {
            return rect1;
        }
        long tx2 = rect1.getWidth();
        long ty2 = rect1.getHeight();
        long rx2 = rect2.getWidth();
        long ry2 = rect2.getHeight();
        int tx1 = rect1.getX();
        int ty1 = rect1.getY();
        tx2 += (long)tx1;
        ty2 += (long)ty1;
        int rx1 = rect2.getX();
        int ry1 = rect2.getY();
        rx2 += (long)rx1;
        ry2 += (long)ry1;
        if (tx1 > rx1) {
            tx1 = rx1;
        }
        if (ty1 > ry1) {
            ty1 = ry1;
        }
        if (tx2 < rx2) {
            tx2 = rx2;
        }
        if (ty2 < ry2) {
            ty2 = ry2;
        }
        tx2 -= (long)tx1;
        ty2 -= (long)ty1;
        tx2 = Math.min(tx2, Integer.MAX_VALUE);
        ty2 = Math.min(ty2, Integer.MAX_VALUE);
        return new ImmutableRect2i(tx1, ty1, (int)tx2, (int)ty2);
    }

    public static ImmutableRect2i centerTextArea(ImmutableRect2i outer, Font fontRenderer, String text) {
        int width = fontRenderer.width(text);
        Objects.requireNonNull(fontRenderer);
        int height = 9;
        return MathUtil.centerArea(outer, width, height);
    }

    public static ImmutableRect2i centerTextArea(ImmutableRect2i outer, Font fontRenderer, FormattedText text) {
        int width = fontRenderer.width(text);
        Objects.requireNonNull(fontRenderer);
        int height = 9;
        return MathUtil.centerArea(outer, width, height);
    }

    public static ImmutableRect2i centerArea(ImmutableRect2i outer, int width, int height) {
        return new ImmutableRect2i(outer.getX() + Math.round((float)(outer.getWidth() - width) / 2.0f), outer.getY() + Math.round((float)(outer.getHeight() - height) / 2.0f), width, height);
    }

    public static double distance(Vec2 start, Vec2 end) {
        double a = start.x - end.x;
        double b = start.y - end.y;
        return Math.sqrt(a * a + b * b);
    }

    public static boolean equalRects(Collection<Rect2i> a, Collection<ImmutableRect2i> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (Rect2i aRect : a) {
            if (MathUtil.containsRect(b, aRect)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsRect(Collection<ImmutableRect2i> rects, Rect2i aRect) {
        for (ImmutableRect2i bRect : rects) {
            if (aRect.getX() != bRect.getX() || aRect.getY() != bRect.getY() || aRect.getWidth() != bRect.getWidth() || aRect.getHeight() != bRect.getHeight()) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    private static interface Rectangle2dCropper {
        public ImmutableRect2i crop(ImmutableRect2i var1, ImmutableRect2i var2);
    }
}

