/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import mezz.jei.config.IClientConfig;
import mezz.jei.config.ServerInfo;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketGiveItemStack;
import mezz.jei.network.packets.PacketSetHotbarItemStack;
import mezz.jei.util.CommandUtilServer;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.GiveMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CommandUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private CommandUtil() {
    }

    public static void giveStack(ItemStack itemStack, InputMappings.Input input, IClientConfig clientConfig) {
        GiveMode giveMode = clientConfig.getGiveMode();
        Minecraft minecraft = Minecraft.getInstance();
        ClientPlayerEntity player = minecraft.player;
        if (player == null) {
            LOGGER.error("Can't give stack, there is no player");
            return;
        }
        if (minecraft.screen instanceof CreativeScreen && giveMode == GiveMode.MOUSE_PICKUP) {
            int amount = GiveMode.getStackSize(giveMode, itemStack, input);
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)amount);
            CommandUtilServer.mousePickupItemStack((PlayerEntity)player, sendStack);
        } else if (ServerInfo.isJeiOnServer()) {
            int amount = GiveMode.getStackSize(giveMode, itemStack, input);
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)amount);
            PacketGiveItemStack packet = new PacketGiveItemStack(sendStack, giveMode);
            Network.sendPacketToServer(packet);
        } else {
            int amount = GiveMode.getStackSize(GiveMode.INVENTORY, itemStack, input);
            CommandUtil.giveStackVanilla(itemStack, amount);
        }
    }

    public static void setHotbarStack(ItemStack itemStack, int hotbarSlot) {
        if (ServerInfo.isJeiOnServer()) {
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)itemStack.getMaxStackSize());
            PacketSetHotbarItemStack packet = new PacketSetHotbarItemStack(sendStack, hotbarSlot);
            Network.sendPacketToServer(packet);
        }
    }

    private static void giveStackVanilla(ItemStack itemStack, int amount) {
        if (itemStack.isEmpty()) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Empty itemStack: {}", (Object)stackInfo, (Object)new IllegalArgumentException());
            return;
        }
        Item item = itemStack.getItem();
        ResourceLocation itemResourceLocation = item.getRegistryName();
        ErrorUtil.checkNotNull(itemResourceLocation, "itemStack.getItem().getRegistryName()");
        ClientPlayerEntity sender = Minecraft.getInstance().player;
        if (sender != null) {
            if (sender.createCommandSourceStack().hasPermission(2)) {
                CommandUtil.sendGiveAction(sender, itemStack, amount);
            } else if (sender.isCreative()) {
                CommandUtil.sendCreativeInventoryActions(sender, itemStack, amount);
            } else {
                CommandUtil.sendGiveAction(sender, itemStack, amount);
            }
        }
    }

    private static void sendGiveAction(ClientPlayerEntity sender, ItemStack itemStack, int amount) {
        Object[] commandParameters = CommandUtilServer.getGiveCommandParameters((PlayerEntity)sender, itemStack, amount);
        String fullCommand = "/give " + StringUtils.join((Object[])commandParameters, (String)" ");
        CommandUtil.sendChatMessage(sender, fullCommand);
    }

    private static void sendChatMessage(ClientPlayerEntity sender, String chatMessage) {
        if (chatMessage.length() <= 256) {
            sender.chat(chatMessage);
        } else {
            TranslationTextComponent errorMessage = new TranslationTextComponent("jei.chat.error.command.too.long");
            errorMessage.getStyle().applyFormat(TextFormatting.RED);
            sender.displayClientMessage((ITextComponent)errorMessage, false);
            StringTextComponent chatMessageComponent = new StringTextComponent(chatMessage);
            chatMessageComponent.getStyle().applyFormat(TextFormatting.RED);
            sender.displayClientMessage((ITextComponent)chatMessageComponent, false);
        }
    }

    private static void sendCreativeInventoryActions(ClientPlayerEntity sender, ItemStack stack, int amount) {
        for (int i = 0; i < sender.inventory.items.size() && amount > 0; ++i) {
            ItemStack currentStack = (ItemStack)sender.inventory.items.get(i);
            if (currentStack.isEmpty()) {
                ItemStack sendAllRemaining = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
                CommandUtil.sendSlotPacket(sendAllRemaining, i);
                amount = 0;
                continue;
            }
            if (!currentStack.sameItem(stack) || currentStack.getMaxStackSize() <= currentStack.getCount()) continue;
            int canAdd = Math.min(currentStack.getMaxStackSize() - currentStack.getCount(), amount);
            ItemStack fillRemainingSpace = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(canAdd + currentStack.getCount()));
            CommandUtil.sendSlotPacket(fillRemainingSpace, i);
            amount -= canAdd;
        }
        if (amount > 0) {
            ItemStack toDrop = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
            CommandUtil.sendSlotPacket(toDrop, -1);
        }
    }

    private static void sendSlotPacket(ItemStack stack, int mainInventorySlot) {
        if (mainInventorySlot < 9 && mainInventorySlot != -1) {
            mainInventorySlot += 36;
        }
        Minecraft minecraft = Minecraft.getInstance();
        PlayerController playerController = minecraft.gameMode;
        if (playerController != null) {
            playerController.handleCreativeModeItemAdd(stack, mainInventorySlot);
        } else {
            LOGGER.error("Cannot send slot packet, minecraft.playerController is null");
        }
    }
}

