/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import javax.annotation.Nullable;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.GuiIngredientProperties;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.GridAlignment;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.MouseUtil;
import mezz.jei.input.click.MouseClickState;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.render.IngredientListBatchRenderer;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.util.GiveMode;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemHandlerHelper;

public class IngredientGrid
implements IShowsRecipeFocuses {
    private static final int INGREDIENT_PADDING = 1;
    public static final int INGREDIENT_WIDTH = GuiIngredientProperties.getWidth(1);
    public static final int INGREDIENT_HEIGHT = GuiIngredientProperties.getHeight(1);
    private final GridAlignment alignment;
    private final RecipesGui recipesGui;
    private final GuiScreenHelper guiScreenHelper;
    private final IMouseHandler mouseHandler;
    private Rectangle2d area = new Rectangle2d(0, 0, 0, 0);
    protected final IngredientListBatchRenderer guiIngredientSlots;
    private final IIngredientFilterConfig ingredientFilterConfig;
    private final IClientConfig clientConfig;
    private final IWorldConfig worldConfig;

    public IngredientGrid(GridAlignment alignment, IEditModeConfig editModeConfig, IIngredientFilterConfig ingredientFilterConfig, IClientConfig clientConfig, IWorldConfig worldConfig, GuiScreenHelper guiScreenHelper, RecipesGui recipesGui) {
        this.alignment = alignment;
        this.recipesGui = recipesGui;
        this.guiIngredientSlots = new IngredientListBatchRenderer(editModeConfig, worldConfig);
        this.ingredientFilterConfig = ingredientFilterConfig;
        this.clientConfig = clientConfig;
        this.worldConfig = worldConfig;
        this.guiScreenHelper = guiScreenHelper;
        this.mouseHandler = new MouseHandler();
    }

    public int size() {
        return this.guiIngredientSlots.size();
    }

    public int maxWidth() {
        int columns = this.clientConfig.getMaxColumns();
        int ingredientsWidth = columns * INGREDIENT_WIDTH;
        int minWidth = this.clientConfig.getMinColumns() * INGREDIENT_WIDTH;
        return Math.max(ingredientsWidth, minWidth);
    }

    public boolean updateBounds(Rectangle2d availableArea, Collection<Rectangle2d> exclusionAreas) {
        int columns = Math.min(availableArea.getWidth() / INGREDIENT_WIDTH, this.clientConfig.getMaxColumns());
        int rows = availableArea.getHeight() / INGREDIENT_HEIGHT;
        int ingredientsWidth = columns * INGREDIENT_WIDTH;
        int minWidth = this.clientConfig.getMinColumns() * INGREDIENT_WIDTH;
        int width = Math.max(ingredientsWidth, minWidth);
        int height = rows * INGREDIENT_HEIGHT;
        int x = this.alignment == GridAlignment.LEFT ? availableArea.getX() + (availableArea.getWidth() - width) : availableArea.getX();
        int y = availableArea.getY() + (availableArea.getHeight() - height) / 2;
        int xOffset = x + Math.max(0, (width - ingredientsWidth) / 2);
        this.area = new Rectangle2d(x, y, width, height);
        this.guiIngredientSlots.clear();
        if (rows == 0 || columns < this.clientConfig.getMinColumns()) {
            return false;
        }
        for (int row = 0; row < rows; ++row) {
            int y1 = y + row * INGREDIENT_HEIGHT;
            for (int column = 0; column < columns; ++column) {
                int x1 = xOffset + column * INGREDIENT_WIDTH;
                IngredientListSlot ingredientListSlot = new IngredientListSlot(x1, y1, 1);
                Rectangle2d stackArea = ingredientListSlot.getArea();
                boolean blocked = MathUtil.intersects(exclusionAreas, stackArea);
                ingredientListSlot.setBlocked(blocked);
                this.guiIngredientSlots.add(ingredientListSlot);
            }
        }
        return true;
    }

    public Rectangle2d getArea() {
        return this.area;
    }

    public void draw(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        IngredientListElementRenderer<?> hovered;
        RenderSystem.disableBlend();
        this.guiIngredientSlots.render(minecraft, matrixStack);
        if (!this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY) && this.isMouseOver(mouseX, mouseY) && (hovered = this.guiIngredientSlots.getHovered(mouseX, mouseY)) != null) {
            hovered.drawHighlight(matrixStack);
        }
        RenderSystem.enableAlphaTest();
    }

    public void drawTooltips(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
                TranslationTextComponent deleteItem = new TranslationTextComponent("jei.tooltip.delete.item");
                TooltipRenderer.drawHoveringText((ITextProperties)deleteItem, mouseX, mouseY, matrixStack);
            } else {
                IngredientListElementRenderer<?> hovered = this.guiIngredientSlots.getHovered(mouseX, mouseY);
                if (hovered != null) {
                    hovered.drawTooltip(matrixStack, mouseX, mouseY, this.ingredientFilterConfig, this.worldConfig);
                }
            }
        }
    }

    private boolean shouldDeleteItemOnClick(Minecraft minecraft, double mouseX, double mouseY) {
        IClickedIngredient<?> ingredientUnderMouse;
        if (!this.worldConfig.isDeleteItemsInCheatModeActive()) {
            return false;
        }
        ClientPlayerEntity player = minecraft.player;
        if (player == null) {
            return false;
        }
        ItemStack itemStack = player.inventory.getCarried();
        if (itemStack.isEmpty()) {
            return false;
        }
        if (this.recipesGui.isOpen()) {
            return false;
        }
        GiveMode giveMode = this.clientConfig.getGiveMode();
        if (giveMode == GiveMode.MOUSE_PICKUP && (ingredientUnderMouse = this.getIngredientUnderMouse(mouseX, mouseY)) != null && ingredientUnderMouse.getValue() instanceof ItemStack) {
            ItemStack value = (ItemStack)ingredientUnderMouse.getValue();
            return !ItemHandlerHelper.canItemStacksStack((ItemStack)itemStack, (ItemStack)value);
        }
        return true;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return MathUtil.contains(this.area, mouseX, mouseY) && !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY);
    }

    @Nullable
    public IIngredientListElement<?> getElementUnderMouse() {
        IngredientListElementRenderer<?> hovered = this.guiIngredientSlots.getHovered(MouseUtil.getX(), MouseUtil.getY());
        if (hovered != null) {
            return hovered.getElement();
        }
        return null;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ClickedIngredient<?> clicked = this.guiIngredientSlots.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked != null) {
                clicked.setAllowsCheating();
            }
            return clicked;
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }

    public IMouseHandler getMouseHandler() {
        return this.mouseHandler;
    }

    private class MouseHandler
    implements IMouseHandler {
        private MouseHandler() {
        }

        @Override
        @Nullable
        public IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
            if (!IngredientGrid.this.isMouseOver(mouseX, mouseY)) {
                return null;
            }
            Minecraft minecraft = Minecraft.getInstance();
            if (!IngredientGrid.this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
                return null;
            }
            ClientPlayerEntity player = minecraft.player;
            if (player == null) {
                return null;
            }
            ItemStack itemStack = player.inventory.getCarried();
            if (itemStack.isEmpty()) {
                return null;
            }
            if (!clickState.isSimulate()) {
                player.inventory.setCarried(ItemStack.EMPTY);
                PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
                Network.sendPacketToServer(packet);
            }
            return this;
        }
    }
}

