/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.ghost.GhostIngredientDrag;
import mezz.jei.gui.ghost.GhostIngredientReturning;
import mezz.jei.gui.ghost.IGhostIngredientDragSource;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseDragHandler;
import mezz.jei.input.click.MouseClickState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.item.ItemStack;

public class GhostIngredientDragManager {
    private final IGhostIngredientDragSource source;
    private final GuiScreenHelper guiScreenHelper;
    private final IngredientManager ingredientManager;
    private final IWorldConfig worldConfig;
    private final List<GhostIngredientReturning<?>> ghostIngredientsReturning = new ArrayList();
    private final IMouseDragHandler mouseDragHandler;
    @Nullable
    private GhostIngredientDrag<?> ghostIngredientDrag;
    @Nullable
    private Object hoveredIngredient;
    @Nullable
    private List<IGhostIngredientHandler.Target<Object>> hoveredIngredientTargets;

    public GhostIngredientDragManager(IGhostIngredientDragSource source, GuiScreenHelper guiScreenHelper, IngredientManager ingredientManager, IWorldConfig worldConfig) {
        this.source = source;
        this.guiScreenHelper = guiScreenHelper;
        this.ingredientManager = ingredientManager;
        this.worldConfig = worldConfig;
        this.mouseDragHandler = new MouseDragHandler();
    }

    public void drawTooltips(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        if (!(minecraft.screen instanceof ContainerScreen)) {
            this.drawGhostIngredientHighlights(minecraft, matrixStack, mouseX, mouseY);
        }
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.drawItem(minecraft, matrixStack, mouseX, mouseY);
        }
        this.ghostIngredientsReturning.forEach(returning -> returning.drawItem(minecraft, matrixStack));
        this.ghostIngredientsReturning.removeIf(GhostIngredientReturning::isComplete);
    }

    public void drawOnForeground(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        this.drawGhostIngredientHighlights(minecraft, matrixStack, mouseX, mouseY);
    }

    private void drawGhostIngredientHighlights(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.drawTargets(matrixStack, mouseX, mouseY);
        } else {
            Object hovered;
            IClickedIngredient<?> elementUnderMouse = this.source.getIngredientUnderMouse(mouseX, mouseY);
            Object i = hovered = elementUnderMouse == null ? null : (Object)elementUnderMouse.getValue();
            if (!Objects.equals(hovered, this.hoveredIngredient)) {
                IGhostIngredientHandler<Screen> handler;
                this.hoveredIngredient = hovered;
                this.hoveredIngredientTargets = null;
                Screen currentScreen = minecraft.screen;
                if (currentScreen != null && hovered != null && (handler = this.guiScreenHelper.getGhostIngredientHandler(currentScreen)) != null && handler.shouldHighlightTargets()) {
                    this.hoveredIngredientTargets = handler.getTargets(currentScreen, hovered, false);
                }
            }
            if (this.hoveredIngredientTargets != null && !this.worldConfig.isCheatItemsEnabled()) {
                GhostIngredientDrag.drawTargets(matrixStack, mouseX, mouseY, this.hoveredIngredientTargets);
            }
        }
    }

    public void stopDrag() {
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.stop();
            this.ghostIngredientDrag = null;
        }
        this.hoveredIngredientTargets = null;
    }

    private <T extends Screen, V> boolean handleClickGhostIngredient(T currentScreen, IClickedIngredient<V> clicked, double mouseX, double mouseY) {
        IGhostIngredientHandler<T> handler = this.guiScreenHelper.getGhostIngredientHandler(currentScreen);
        if (handler == null) {
            return false;
        }
        V ingredient = clicked.getValue();
        List targets = handler.getTargets(currentScreen, ingredient, true);
        if (targets.isEmpty()) {
            return false;
        }
        IIngredientRenderer<V> ingredientRenderer = this.ingredientManager.getIngredientRenderer(ingredient);
        Rectangle2d clickedArea = clicked.getArea();
        this.ghostIngredientDrag = new GhostIngredientDrag(handler, targets, ingredientRenderer, ingredient, mouseX, mouseY, clickedArea);
        return true;
    }

    public IMouseDragHandler getMouseDragHandler() {
        return this.mouseDragHandler;
    }

    private class MouseDragHandler
    implements IMouseDragHandler {
        private MouseDragHandler() {
        }

        @Override
        @Nullable
        public IMouseDragHandler handleDragStart(Screen screen, double mouseX, double mouseY) {
            if (screen instanceof RecipesGui) {
                return null;
            }
            IClickedIngredient<?> clicked = GhostIngredientDragManager.this.source.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked == null) {
                return null;
            }
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft == null) {
                return null;
            }
            ClientPlayerEntity player = minecraft.player;
            if (player == null) {
                return null;
            }
            ItemStack mouseItem = player.inventory.getCarried();
            if (mouseItem.isEmpty() && GhostIngredientDragManager.this.handleClickGhostIngredient(screen, clicked, mouseX, mouseY)) {
                return this;
            }
            return null;
        }

        @Override
        @Nullable
        public IMouseDragHandler handleDragComplete(Screen screen, double mouseX, double mouseY) {
            if (screen instanceof RecipesGui) {
                return null;
            }
            if (GhostIngredientDragManager.this.ghostIngredientDrag == null) {
                return null;
            }
            boolean success = GhostIngredientDragManager.this.ghostIngredientDrag.onClick(mouseX, mouseY, MouseClickState.EXECUTE);
            if (!success && GhostIngredientDrag.farEnoughToDraw(GhostIngredientDragManager.this.ghostIngredientDrag, mouseX, mouseY)) {
                GhostIngredientReturning returning = GhostIngredientReturning.create(GhostIngredientDragManager.this.ghostIngredientDrag, mouseX, mouseY);
                GhostIngredientDragManager.this.ghostIngredientsReturning.add(returning);
            }
            GhostIngredientDragManager.this.ghostIngredientDrag = null;
            GhostIngredientDragManager.this.hoveredIngredientTargets = null;
            if (success) {
                return this;
            }
            return null;
        }

        @Override
        public void handleDragCanceled() {
            GhostIngredientDragManager.this.stopDrag();
        }
    }
}

