/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemStackFastRenderer
extends IngredientListElementRenderer<ItemStack> {
    public ItemStackFastRenderer(IIngredientListElement<ItemStack> itemStackElement) {
        super(itemStackElement);
    }

    public void renderItemAndEffectIntoGUI(MatrixStack matrixStack, IEditModeConfig editModeConfig, IWorldConfig worldConfig) {
        try {
            this.uncheckedRenderItemAndEffectIntoGUI(matrixStack, editModeConfig, worldConfig);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, this.element.getIngredient());
        }
    }

    @Nullable
    private IBakedModel getBakedModel() {
        ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        IBakedModel bakedModel = itemModelMesher.func_178089_a(itemStack);
        return bakedModel.func_188617_f().func_239290_a_(bakedModel, itemStack, null, null);
    }

    private void uncheckedRenderItemAndEffectIntoGUI(MatrixStack matrixStack, IEditModeConfig editModeConfig, IWorldConfig worldConfig) {
        if (worldConfig.isEditModeEnabled()) {
            this.renderEditMode(matrixStack, this.area, this.padding, editModeConfig);
            RenderSystem.enableBlend();
        }
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        IBakedModel bakedModel = this.getBakedModel();
        if (bakedModel == null) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(this.area.func_199318_a() + this.padding + 16), (double)(this.area.func_199319_b() + this.padding), 150.0);
        matrixStack.func_227862_a_(16.0f, -16.0f, 16.0f);
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        Minecraft minecraft = Minecraft.func_71410_x();
        ItemRenderer itemRenderer = minecraft.func_175599_af();
        IRenderTypeBuffer.Impl iRenderTypeBuffer = minecraft.func_228019_au_().func_228487_b_();
        itemRenderer.func_229111_a_(itemStack, ItemCameraTransforms.TransformType.GUI, false, matrixStack, (IRenderTypeBuffer)iRenderTypeBuffer, 0xF000F0, OverlayTexture.field_229196_a_, bakedModel);
        iRenderTypeBuffer.func_228461_a_();
        matrixStack.func_227865_b_();
    }

    public void renderOverlay() {
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        try {
            this.renderOverlay(itemStack, this.area, this.padding);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, this.element.getIngredient());
        }
    }

    private void renderOverlay(ItemStack itemStack, Rectangle2d area, int padding) {
        FontRenderer font = ItemStackFastRenderer.getFontRenderer(itemStack);
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        itemRenderer.func_180453_a(font, itemStack, area.func_199318_a() + padding, area.func_199319_b() + padding, null);
    }

    public static FontRenderer getFontRenderer(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        FontRenderer fontRenderer = item.getFontRenderer(itemStack);
        if (fontRenderer == null) {
            fontRenderer = Minecraft.func_71410_x().field_71466_p;
        }
        return fontRenderer;
    }
}

