/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.config.IFilterTextSource;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.PageNavigation;
import mezz.jei.gui.ghost.IGhostIngredientDragSource;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IPaged;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.MouseUtil;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.util.CommandUtil;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Rectangle2dBuilder;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;

public class IngredientGridWithNavigation
implements IShowsRecipeFocuses,
IMouseHandler,
IGhostIngredientDragSource {
    private static final int NAVIGATION_HEIGHT = 20;
    private int firstItemIndex = 0;
    private final IPaged pageDelegate;
    private final PageNavigation navigation;
    private final GuiScreenHelper guiScreenHelper;
    private final IFilterTextSource filterTextSource;
    private final IWorldConfig worldConfig;
    private final IngredientGrid ingredientGrid;
    private final IIngredientGridSource ingredientSource;
    private Rectangle2d area = new Rectangle2d(0, 0, 0, 0);

    public IngredientGridWithNavigation(IIngredientGridSource ingredientSource, IFilterTextSource filterTextSource, GuiScreenHelper guiScreenHelper, IngredientGrid ingredientGrid, IWorldConfig worldConfig) {
        this.filterTextSource = filterTextSource;
        this.worldConfig = worldConfig;
        this.ingredientGrid = ingredientGrid;
        this.ingredientSource = ingredientSource;
        this.guiScreenHelper = guiScreenHelper;
        this.pageDelegate = new IngredientGridPaged();
        this.navigation = new PageNavigation(this.pageDelegate, false);
    }

    public void updateLayout(boolean resetToFirstPage) {
        String filterText;
        List<IIngredientListElement<?>> ingredientList;
        if (resetToFirstPage) {
            this.firstItemIndex = 0;
        }
        if (this.firstItemIndex >= (ingredientList = this.ingredientSource.getIngredientList(filterText = this.filterTextSource.getFilterText())).size()) {
            this.firstItemIndex = 0;
        }
        this.ingredientGrid.guiIngredientSlots.set(this.firstItemIndex, ingredientList);
        this.navigation.updatePageState();
    }

    public boolean updateBounds(Rectangle2d availableArea, Set<Rectangle2d> guiExclusionAreas) {
        Tuple<Rectangle2d, Rectangle2d> result = MathUtil.splitY(availableArea, 20);
        Rectangle2d estimatedNavigationArea = (Rectangle2d)result.func_76341_a();
        Rectangle2d movedNavigationArea = MathUtil.moveDownToAvoidIntersection(guiExclusionAreas, estimatedNavigationArea);
        int navigationMaxY = movedNavigationArea.func_199319_b() + movedNavigationArea.func_199317_d();
        result = MathUtil.splitY(availableArea, navigationMaxY);
        Rectangle2d navigationArea = (Rectangle2d)result.func_76341_a();
        Rectangle2d boundsWithoutNavigation = (Rectangle2d)result.func_76340_b();
        boolean gridHasRoom = this.ingredientGrid.updateBounds(boundsWithoutNavigation, guiExclusionAreas);
        if (!gridHasRoom) {
            return false;
        }
        Rectangle2d displayArea = this.ingredientGrid.getArea();
        navigationArea = new Rectangle2dBuilder(navigationArea).setX(displayArea).setWidth(displayArea).build();
        this.navigation.updateBounds(navigationArea);
        this.area = MathUtil.union(displayArea, navigationArea);
        return true;
    }

    public Rectangle2d getArea() {
        return this.area;
    }

    public void draw(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.ingredientGrid.draw(minecraft, matrixStack, mouseX, mouseY);
        this.navigation.draw(minecraft, matrixStack, mouseX, mouseY, partialTicks);
    }

    public void drawTooltips(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        this.ingredientGrid.drawTooltips(minecraft, matrixStack, mouseX, mouseY);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return MathUtil.contains(this.area, mouseX, mouseY) && !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY);
    }

    @Override
    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.isMouseOver(mouseX, mouseY) && (this.ingredientGrid.handleMouseClicked(mouseX, mouseY) || this.navigation.handleMouseClickedButtons(mouseX, mouseY, mouseButton));
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        if (scrollDelta < 0.0) {
            this.pageDelegate.nextPage();
            return true;
        }
        if (scrollDelta > 0.0) {
            this.pageDelegate.previousPage();
            return true;
        }
        return false;
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input input = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (KeyBindings.nextPage.isActiveAndMatches(input)) {
            this.pageDelegate.nextPage();
            return true;
        }
        if (KeyBindings.previousPage.isActiveAndMatches(input)) {
            this.pageDelegate.previousPage();
            return true;
        }
        return this.checkHotbarKeys(input);
    }

    protected boolean checkHotbarKeys(InputMappings.Input input) {
        double mouseY;
        double mouseX;
        Screen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (this.worldConfig.isCheatItemsEnabled() && guiScreen != null && !(guiScreen instanceof RecipesGui) && this.isMouseOver(mouseX = MouseUtil.getX(), mouseY = MouseUtil.getY())) {
            GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
            for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
                if (!gameSettings.field_151456_ac[hotbarSlot].isActiveAndMatches(input)) continue;
                IClickedIngredient<?> ingredientUnderMouse = this.getIngredientUnderMouse(mouseX, mouseY);
                if (ingredientUnderMouse != null) {
                    ItemStack itemStack = ingredientUnderMouse.getCheatItemStack();
                    if (!itemStack.func_190926_b()) {
                        CommandUtil.setHotbarStack(itemStack, hotbarSlot);
                    }
                    ingredientUnderMouse.onClickHandled();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        return this.ingredientGrid.getIngredientUnderMouse(mouseX, mouseY);
    }

    @Override
    @Nullable
    public IIngredientListElement<?> getElementUnderMouse() {
        return this.ingredientGrid.getElementUnderMouse();
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return this.ingredientGrid.canSetFocusWithMouse();
    }

    public List<IIngredientListElement<?>> getVisibleElements() {
        ArrayList visibleElements = new ArrayList();
        for (IngredientListSlot slot : this.ingredientGrid.guiIngredientSlots.getAllGuiIngredientSlots()) {
            IngredientListElementRenderer<?> renderer = slot.getIngredientRenderer();
            if (renderer == null) continue;
            visibleElements.add(renderer.getElement());
        }
        return visibleElements;
    }

    private class IngredientGridPaged
    implements IPaged {
        private IngredientGridPaged() {
        }

        @Override
        public boolean nextPage() {
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemsCount = IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size();
            if (itemsCount > 0) {
                IngredientGridWithNavigation.this.firstItemIndex = IngredientGridWithNavigation.this.firstItemIndex + IngredientGridWithNavigation.this.ingredientGrid.size();
                if (IngredientGridWithNavigation.this.firstItemIndex >= itemsCount) {
                    IngredientGridWithNavigation.this.firstItemIndex = 0;
                }
                IngredientGridWithNavigation.this.updateLayout(false);
                return true;
            }
            IngredientGridWithNavigation.this.firstItemIndex = 0;
            IngredientGridWithNavigation.this.updateLayout(false);
            return false;
        }

        @Override
        public boolean previousPage() {
            int itemsPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            if (itemsPerPage == 0) {
                IngredientGridWithNavigation.this.firstItemIndex = 0;
                IngredientGridWithNavigation.this.updateLayout(false);
                return false;
            }
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemsCount = IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size();
            int pageNum = IngredientGridWithNavigation.this.firstItemIndex / itemsPerPage;
            pageNum = pageNum == 0 ? itemsCount / itemsPerPage : --pageNum;
            IngredientGridWithNavigation.this.firstItemIndex = itemsPerPage * pageNum;
            if (IngredientGridWithNavigation.this.firstItemIndex > 0 && IngredientGridWithNavigation.this.firstItemIndex == itemsCount) {
                IngredientGridWithNavigation.this.firstItemIndex = itemsPerPage * --pageNum;
            }
            IngredientGridWithNavigation.this.updateLayout(false);
            return true;
        }

        @Override
        public boolean hasNext() {
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemsPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            return itemsPerPage > 0 && IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size() > itemsPerPage;
        }

        @Override
        public boolean hasPrevious() {
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemsPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            return itemsPerPage > 0 && IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size() > itemsPerPage;
        }

        @Override
        public int getPageCount() {
            String filterText = IngredientGridWithNavigation.this.filterTextSource.getFilterText();
            int itemCount = IngredientGridWithNavigation.this.ingredientSource.getIngredientList(filterText).size();
            int stacksPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            if (stacksPerPage == 0) {
                return 1;
            }
            int pageCount = MathUtil.divideCeil(itemCount, stacksPerPage);
            pageCount = Math.max(1, pageCount);
            return pageCount;
        }

        @Override
        public int getPageNumber() {
            int stacksPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            if (stacksPerPage == 0) {
                return 0;
            }
            return IngredientGridWithNavigation.this.firstItemIndex / stacksPerPage;
        }
    }
}

