/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import java.util.function.Predicate;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.config.BookmarkConfig;
import mezz.jei.config.EditModeConfig;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IngredientFilterConfig;
import mezz.jei.config.JEIClientConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.ModIdFormattingConfig;
import mezz.jei.config.WorldConfig;
import mezz.jei.config.sorting.ModNameSortingConfig;
import mezz.jei.config.sorting.RecipeCategorySortingConfig;
import mezz.jei.events.EventBusHelper;
import mezz.jei.events.PlayerJoinedWorldEvent;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.ForgeModIdHelper;
import mezz.jei.startup.JeiStarter;
import mezz.jei.startup.NetworkHandler;
import mezz.jei.util.AnnotatedInstanceUtil;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientLifecycleHandler {
    private final Logger LOGGER = LogManager.getLogger();
    private final JeiStarter starter = new JeiStarter();
    private final Textures textures;
    private final IClientConfig clientConfig;
    private final BookmarkConfig bookmarkConfig;
    private final ModIdFormattingConfig modIdFormattingConfig;
    private final IngredientFilterConfig ingredientFilterConfig;
    private final WorldConfig worldConfig;
    private final IModIdHelper modIdHelper;
    private final IEditModeConfig editModeConfig;
    private final ModNameSortingConfig ingredientModNameSortingConfig;
    private final RecipeCategorySortingConfig recipeCategorySortingConfig;

    public ClientLifecycleHandler(NetworkHandler networkHandler, Textures textures) {
        File jeiConfigurationDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "jei");
        if (!jeiConfigurationDir.exists()) {
            try {
                if (!jeiConfigurationDir.mkdir()) {
                    throw new RuntimeException("Could not create config directory " + jeiConfigurationDir);
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException("Could not create config directory " + jeiConfigurationDir, e);
            }
        }
        this.clientConfig = JEIClientConfig.clientConfig;
        this.ingredientFilterConfig = JEIClientConfig.filterConfig;
        this.modIdFormattingConfig = JEIClientConfig.modNameFormat;
        this.modIdHelper = new ForgeModIdHelper(this.clientConfig, this.modIdFormattingConfig);
        this.bookmarkConfig = new BookmarkConfig(jeiConfigurationDir);
        this.worldConfig = new WorldConfig(jeiConfigurationDir);
        this.editModeConfig = new EditModeConfig(jeiConfigurationDir);
        File ingredientModSortOrderFile = new File(jeiConfigurationDir, "ingredient-list-mod-sort-order.ini");
        this.ingredientModNameSortingConfig = new ModNameSortingConfig(ingredientModSortOrderFile);
        File recipeCategoryModSortOrderFile = new File(jeiConfigurationDir, "recipe-category-sort-order.ini");
        this.recipeCategorySortingConfig = new RecipeCategorySortingConfig(recipeCategoryModSortOrderFile);
        ErrorUtil.setModIdHelper(this.modIdHelper);
        ErrorUtil.setWorldConfig(this.worldConfig);
        KeyBindings.init();
        EventBusHelper.addListener(WorldEvent.Save.class, event -> this.worldConfig.onWorldSave());
        EventBusHelper.addListener(RecipesUpdatedEvent.class, event -> {
            ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
            if (connection != null) {
                NetworkManager networkManager = connection.func_147298_b();
                this.worldConfig.syncWorldConfig(networkManager);
            }
            this.onRecipesLoaded();
            EventBusHelper.post(new PlayerJoinedWorldEvent());
        });
        networkHandler.createClientPacketHandler(this.worldConfig);
        this.textures = textures;
    }

    private void onRecipesLoaded() {
        this.modIdFormattingConfig.checkForModNameFormatOverride();
        List<IModPlugin> plugins = AnnotatedInstanceUtil.getModPlugins();
        Minecraft minecraft = Minecraft.func_71410_x();
        IResourceManager resourceManager = minecraft.func_195551_G();
        if (resourceManager instanceof IReloadableResourceManager) {
            IReloadableResourceManager reloadableResourceManager = (IReloadableResourceManager)resourceManager;
            reloadableResourceManager.func_219534_a((IFutureReloadListener)new JeiReloadListener(plugins));
        }
        if (minecraft.field_71441_e != null) {
            Preconditions.checkNotNull((Object)this.textures);
            this.starter.start(plugins, this.textures, this.clientConfig, this.editModeConfig, this.ingredientFilterConfig, this.worldConfig, this.bookmarkConfig, this.modIdHelper, this.ingredientModNameSortingConfig, this.recipeCategorySortingConfig);
        }
    }

    private final class JeiReloadListener
    implements ISelectiveResourceReloadListener {
        private final List<IModPlugin> plugins;

        private JeiReloadListener(List<IModPlugin> plugins) {
            this.plugins = plugins;
        }

        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
            if (ClientLifecycleHandler.this.starter.hasStarted() && Minecraft.func_71410_x().field_71441_e != null) {
                ClientLifecycleHandler.this.LOGGER.info("Restarting JEI.");
                Preconditions.checkNotNull((Object)ClientLifecycleHandler.this.textures);
                ClientLifecycleHandler.this.starter.start(this.plugins, ClientLifecycleHandler.this.textures, ClientLifecycleHandler.this.clientConfig, ClientLifecycleHandler.this.editModeConfig, ClientLifecycleHandler.this.ingredientFilterConfig, ClientLifecycleHandler.this.worldConfig, ClientLifecycleHandler.this.bookmarkConfig, ClientLifecycleHandler.this.modIdHelper, ClientLifecycleHandler.this.ingredientModNameSortingConfig, ClientLifecycleHandler.this.recipeCategorySortingConfig);
            }
        }
    }
}

