/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.ISlowRenderItem;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.render.ItemStackFastRenderer;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientListBatchRenderer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<IngredientListSlot> slots = new ArrayList<IngredientListSlot>();
    private final List<ItemStackFastRenderer> renderItems2d = new ArrayList<ItemStackFastRenderer>();
    private final List<ItemStackFastRenderer> renderItems3d = new ArrayList<ItemStackFastRenderer>();
    private final List<IngredientListElementRenderer<?>> renderOther = new ArrayList();
    private final IEditModeConfig editModeConfig;
    private final IWorldConfig worldConfig;
    private int blocked = 0;

    public IngredientListBatchRenderer(IEditModeConfig editModeConfig, IWorldConfig worldConfig) {
        this.editModeConfig = editModeConfig;
        this.worldConfig = worldConfig;
    }

    public void clear() {
        this.slots.clear();
        this.renderItems2d.clear();
        this.renderItems3d.clear();
        this.renderOther.clear();
        this.blocked = 0;
    }

    public int size() {
        return this.slots.size() - this.blocked;
    }

    public void add(IngredientListSlot ingredientListSlot) {
        this.slots.add(ingredientListSlot);
    }

    public List<IngredientListSlot> getAllGuiIngredientSlots() {
        return this.slots;
    }

    public void set(int startIndex, List<IIngredientListElement<?>> ingredientList) {
        this.renderItems2d.clear();
        this.renderItems3d.clear();
        this.renderOther.clear();
        this.blocked = 0;
        int i = startIndex;
        for (IngredientListSlot ingredientListSlot : this.slots) {
            if (ingredientListSlot.isBlocked()) {
                ingredientListSlot.clear();
                ++this.blocked;
                continue;
            }
            if (i >= ingredientList.size()) {
                ingredientListSlot.clear();
            } else {
                IIngredientListElement<?> element = ingredientList.get(i);
                this.set(ingredientListSlot, element);
            }
            ++i;
        }
    }

    private <V> void set(IngredientListSlot ingredientListSlot, IIngredientListElement<V> element) {
        ingredientListSlot.clear();
        V ingredient = element.getIngredient();
        if (ingredient instanceof ItemStack) {
            IBakedModel bakedModel;
            IIngredientListElement<ItemStack> itemStackElement = element;
            ItemStack itemStack = (ItemStack)itemStackElement.getIngredient();
            ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
            try {
                bakedModel = itemModelMesher.func_178089_a(itemStack);
                bakedModel = bakedModel.func_188617_f().func_239290_a_(bakedModel, itemStack, null, null);
                Preconditions.checkNotNull((Object)bakedModel, (Object)"IBakedModel must not be null.");
            }
            catch (Throwable throwable) {
                String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
                LOGGER.error("ItemStack crashed getting IBakedModel. {}", (Object)stackInfo, (Object)throwable);
                return;
            }
            if (!bakedModel.func_188618_c() && !(itemStack.func_77973_b() instanceof ISlowRenderItem)) {
                ItemStackFastRenderer renderer = new ItemStackFastRenderer(itemStackElement);
                ingredientListSlot.setIngredientRenderer(renderer);
                if (bakedModel.func_230044_c_()) {
                    this.renderItems3d.add(renderer);
                } else {
                    this.renderItems2d.add(renderer);
                }
                return;
            }
        }
        IngredientListElementRenderer<V> renderer = new IngredientListElementRenderer<V>(element);
        ingredientListSlot.setIngredientRenderer(renderer);
        this.renderOther.add(renderer);
    }

    @Nullable
    public ClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        IngredientListElementRenderer<?> hovered = this.getHovered(mouseX, mouseY);
        if (hovered != null) {
            IIngredientListElement<?> element = hovered.getElement();
            return ClickedIngredient.create(element.getIngredient(), hovered.getArea());
        }
        return null;
    }

    @Nullable
    public IngredientListElementRenderer<?> getHovered(double mouseX, double mouseY) {
        for (IngredientListSlot slot : this.slots) {
            if (!slot.isMouseOver(mouseX, mouseY)) continue;
            return slot.getIngredientRenderer();
        }
        return null;
    }

    public void render(Minecraft minecraft, MatrixStack matrixStack) {
        RenderHelper.func_227780_a_();
        ItemRenderer itemRenderer = minecraft.func_175599_af();
        TextureManager textureManager = minecraft.func_110434_K();
        itemRenderer.field_77023_b += 50.0f;
        textureManager.func_110577_a(PlayerContainer.field_226615_c_);
        textureManager.func_229267_b_(PlayerContainer.field_226615_c_).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableLighting();
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems3d) {
            itemStackFastRenderer.renderItemAndEffectIntoGUI(matrixStack, this.editModeConfig, this.worldConfig);
        }
        RenderSystem.disableLighting();
        RenderHelper.func_227783_c_();
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems2d) {
            itemStackFastRenderer.renderItemAndEffectIntoGUI(matrixStack, this.editModeConfig, this.worldConfig);
        }
        RenderHelper.func_227784_d_();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableLighting();
        textureManager.func_110577_a(PlayerContainer.field_226615_c_);
        textureManager.func_229267_b_(PlayerContainer.field_226615_c_).restoreLastBlurMipmap();
        itemRenderer.field_77023_b -= 50.0f;
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems3d) {
            itemStackFastRenderer.renderOverlay();
        }
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems2d) {
            itemStackFastRenderer.renderOverlay();
        }
        RenderSystem.disableLighting();
        for (IngredientListElementRenderer ingredientListElementRenderer : this.renderOther) {
            ingredientListElementRenderer.renderSlow(matrixStack, this.editModeConfig, this.worldConfig);
        }
        RenderHelper.func_74518_a();
    }
}

