/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config.sorting;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SortingConfig<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final File file;
    @Nullable
    private List<T> sorted;

    public SortingConfig(File file) {
        this.file = file;
    }

    protected abstract List<T> read(Reader var1) throws IOException;

    protected abstract void write(FileWriter var1, List<T> var2) throws IOException;

    protected abstract Comparator<T> getDefaultSortOrder();

    private void save(List<T> sorted) {
        try (FileWriter writer = new FileWriter(this.file);){
            this.write(writer, sorted);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save to file {}", (Object)this.file, (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private List<T> loadSortedFromFile() {
        File file = this.file;
        if (!file.exists()) return null;
        try (FileReader reader = new FileReader(file);){
            List<T> list = this.read(reader);
            return list;
        }
        catch (IOException e) {
            LOGGER.error("Failed to load from file {}", (Object)file, (Object)e);
        }
        return null;
    }

    private void load(Set<T> allValues) {
        Comparator<Object> sortOrder;
        List<T> sortedOnFile = this.loadSortedFromFile();
        if (sortedOnFile == null) {
            sortOrder = this.getDefaultSortOrder();
        } else {
            Comparator<Object> existingOrder = Comparator.comparingInt(t -> this.indexOfSort(sortedOnFile.indexOf(t)));
            Comparator<T> defaultOrder = this.getDefaultSortOrder();
            sortOrder = existingOrder.thenComparing(defaultOrder);
        }
        this.sorted = allValues.stream().sorted(sortOrder).collect(Collectors.toList());
        if (!Objects.equals(sortedOnFile, this.sorted)) {
            this.save(this.sorted);
        }
    }

    private int indexOfSort(int index) {
        if (index < 0) {
            return Integer.MAX_VALUE;
        }
        return index;
    }

    private List<T> getSorted(Set<T> allValues) {
        if (this.sorted == null) {
            this.load(allValues);
        }
        return this.sorted;
    }

    public <V> Comparator<V> getComparator(Set<T> allValues, Function<V, T> mapping) {
        List<T> sorted = this.getSorted(allValues);
        return Comparator.comparingInt(o -> {
            Object value = mapping.apply(o);
            return this.indexOfSort(sorted.indexOf(value));
        });
    }
}

