/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config.sorting;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.config.sorting.StringSortingConfig;

public abstract class MappedStringSortingConfig<V>
extends StringSortingConfig {
    private final Function<V, String> mapping;

    public MappedStringSortingConfig(File file, Function<V, String> mapping) {
        super(file);
        this.mapping = mapping;
    }

    public Comparator<V> getComparator(Collection<V> allValues) {
        Set allMappedValues = allValues.stream().map(this.mapping).collect(Collectors.toSet());
        return super.getComparator(allMappedValues, this.mapping);
    }

    public Comparator<V> getComparatorFromMappedValues(Set<String> allMappedValues) {
        return super.getComparator(allMappedValues, this.mapping);
    }
}

