/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.Comparator;
import java.util.List;
import mezz.jei.config.sorting.ModNameSortingConfig;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IIngredientListElementInfo;
import mezz.jei.ingredients.IIngredientSorter;
import net.minecraft.item.ItemStack;

public final class IngredientSorter
implements IIngredientSorter {
    private static final Comparator<IIngredientListElementInfo<?>> ITEM_STACK_FIRST = Comparator.comparing(o -> {
        IIngredientListElement element = o.getElement();
        Object ingredient = element.getIngredient();
        return ingredient instanceof ItemStack;
    }).reversed();
    private static final Comparator<IIngredientListElementInfo<?>> CREATIVE = Comparator.comparingInt(o -> {
        IIngredientListElement element = o.getElement();
        return element.getOrderIndex();
    });
    private static final Comparator<IIngredientListElementInfo<?>> ALPHABETICAL = Comparator.comparing(IIngredientListElementInfo::getName);
    private Comparator<IIngredientListElementInfo<?>> modId;
    private Comparator<IIngredientListElementInfo<?>> comparator;

    public IngredientSorter(ModNameSortingConfig modNameSortingConfig) {
        List<String> ordering = modNameSortingConfig.getSorted();
        this.modId = IngredientSorter.createModIdComparator(ordering);
        this.comparator = IngredientSorter.createComparator(this.modId);
        modNameSortingConfig.addListener(this::updateModIdSorting);
    }

    private void updateModIdSorting(List<String> ordering) {
        this.modId = IngredientSorter.createModIdComparator(ordering);
        this.comparator = IngredientSorter.createComparator(this.modId);
    }

    @Override
    public Comparator<IIngredientListElementInfo<?>> getComparator() {
        return this.comparator;
    }

    private static Comparator<IIngredientListElementInfo<?>> createModIdComparator(List<String> ordering) {
        return Comparator.comparingInt(o -> {
            String modNameForSorting = o.getModNameForSorting();
            return ordering.indexOf(modNameForSorting);
        });
    }

    private static Comparator<IIngredientListElementInfo<?>> createComparator(Comparator<IIngredientListElementInfo<?>> modId) {
        return modId.thenComparing(ITEM_STACK_FIRST).thenComparing(CREATIVE);
    }
}

