/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config.sorting;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SortingConfig<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final File file;
    private final Collection<Consumer<List<T>>> listeners = new ArrayList<Consumer<List<T>>>();
    @Nullable
    private List<T> sorted;

    public SortingConfig(File file) {
        this.file = file;
    }

    protected abstract List<T> read(Reader var1) throws IOException;

    protected abstract void write(FileWriter var1, List<T> var2) throws IOException;

    protected abstract Comparator<T> getDefaultSortOrder();

    protected abstract Stream<T> generate();

    private void save() {
        List<T> sorted = this.getSorted();
        try (FileWriter writer = new FileWriter(this.file);){
            this.write(writer, sorted);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save to file {}", (Object)this.file, (Object)e);
        }
    }

    private void load() {
        File file = this.file;
        List<T> sortedOnFile = null;
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                sortedOnFile = this.read(reader);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load from file {}", (Object)file, (Object)e);
            }
        }
        Comparator<Object> sortOrder = this.getDefaultSortOrder();
        if (sortedOnFile != null) {
            Comparator<Object> existingOrder = Comparator.comparing(sortedOnFile::indexOf);
            sortOrder = existingOrder.thenComparing(sortOrder);
        }
        List<T> previousSorted = this.sorted;
        this.sorted = this.generate().sorted(sortOrder).collect(Collectors.toList());
        if (!Objects.equals(previousSorted, this.sorted)) {
            List<T> unmodifiableList = Collections.unmodifiableList(this.sorted);
            for (Consumer<List<List<T>>> consumer : this.listeners) {
                consumer.accept(unmodifiableList);
            }
        }
        if (!Objects.equals(sortedOnFile, this.sorted)) {
            this.save();
        }
    }

    public List<T> getSorted() {
        if (this.sorted == null) {
            this.load();
        }
        return Collections.unmodifiableList(this.sorted);
    }

    public void addListener(Consumer<List<T>> listener) {
        this.listeners.add(listener);
    }
}

