/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.Comparator;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IIngredientListElementInfo;
import net.minecraft.item.ItemStack;

public final class IngredientListElementComparator
implements Comparator<IIngredientListElementInfo<?>> {
    public static final IngredientListElementComparator INSTANCE = new IngredientListElementComparator();

    private IngredientListElementComparator() {
    }

    @Override
    public int compare(IIngredientListElementInfo<?> o1, IIngredientListElementInfo<?> o2) {
        String modName1 = o1.getModNameForSorting();
        String modName2 = o2.getModNameForSorting();
        IIngredientListElement<?> element = o1.getElement();
        if (modName1.equals(modName2)) {
            boolean isItemStack1 = element.getIngredient() instanceof ItemStack;
            boolean isItemStack2 = element.getIngredient() instanceof ItemStack;
            if (isItemStack1 && !isItemStack2) {
                return -1;
            }
            if (!isItemStack1 && isItemStack2) {
                return 1;
            }
            int orderIndex1 = element.getOrderIndex();
            int orderIndex2 = element.getOrderIndex();
            return Integer.compare(orderIndex1, orderIndex2);
        }
        if (modName1.equals("Minecraft")) {
            return -1;
        }
        if (modName2.equals("Minecraft")) {
            return 1;
        }
        return modName1.compareTo(modName2);
    }
}

