/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.debug;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.gui.textures.Textures;
import mezz.jei.plugins.debug.DebugRecipe;
import mezz.jei.plugins.debug.JeiDebugPlugin;
import mezz.jei.plugins.jei.ingredients.DebugIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class DebugRecipeCategory
implements IRecipeCategory<DebugRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("jei", "debug");
    public static final int RECIPE_WIDTH = 160;
    public static final int RECIPE_HEIGHT = 60;
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable tankBackground;
    private final IDrawable tankOverlay;
    private boolean hiddenRecipes;

    public DebugRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, 60);
        this.localizedName = "debug";
        ResourceLocation backgroundTexture = new ResourceLocation("jei", "textures/gui/debug.png");
        this.tankBackground = guiHelper.drawableBuilder(backgroundTexture, 220, 196, 18, 60).addPadding(-1, -1, -1, -1).build();
        this.tankOverlay = guiHelper.drawableBuilder(backgroundTexture, 238, 196, 18, 60).addPadding(-1, -1, -1, -1).build();
    }

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public Class<? extends DebugRecipe> getRecipeClass() {
        return DebugRecipe.class;
    }

    @Override
    public String getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        Textures textures = Internal.getTextures();
        return textures.getConfigButtonIcon();
    }

    @Override
    public void setIngredients(DebugRecipe recipe, IIngredients ingredients) {
        FluidStack water = new FluidStack((Fluid)Fluids.field_204546_a, (int)((1.0 + Math.random()) * 1000.0));
        FluidStack lava = new FluidStack((Fluid)Fluids.field_204547_b, (int)((1.0 + Math.random()) * 1000.0));
        ingredients.setInputs(VanillaTypes.FLUID, Arrays.asList(water, lava));
        ingredients.setInput(VanillaTypes.ITEM, new ItemStack((IItemProvider)Items.field_151055_y));
        ingredients.setInputLists(DebugIngredient.TYPE, Collections.singletonList(Arrays.asList(new DebugIngredient(0), new DebugIngredient(1))));
        ingredients.setOutputs(DebugIngredient.TYPE, Arrays.asList(new DebugIngredient(2), new DebugIngredient(3)));
    }

    @Override
    public void draw(DebugRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        IJeiRuntime runtime = JeiDebugPlugin.jeiRuntime;
        if (runtime != null) {
            IIngredientFilter ingredientFilter = runtime.getIngredientFilter();
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.field_71466_p.func_238421_b_(matrixStack, ingredientFilter.getFilterText(), 20.0f, 52.0f, 0);
            IIngredientListOverlay ingredientListOverlay = runtime.getIngredientListOverlay();
            Object ingredientUnderMouse = ingredientListOverlay.getIngredientUnderMouse();
            if (ingredientUnderMouse != null) {
                this.drawIngredientName(minecraft, matrixStack, ingredientUnderMouse);
            }
        }
        ExtendedButton button = recipe.getButton();
        button.func_230430_a_(matrixStack, (int)mouseX, (int)mouseY, 0.0f);
    }

    private <T> void drawIngredientName(Minecraft minecraft, MatrixStack matrixStack, T ingredient) {
        IIngredientManager ingredientManager = JeiDebugPlugin.ingredientManager;
        if (ingredientManager != null) {
            IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredient);
            String jeiUid = ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
            minecraft.field_71466_p.func_238421_b_(matrixStack, jeiUid, 50.0f, 52.0f, 0);
        }
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, DebugRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                tooltip.add(new StringTextComponent(slotIndex + " Input itemStack"));
            } else {
                tooltip.add(new StringTextComponent(slotIndex + " Output itemStack"));
            }
        });
        guiItemStacks.init(0, false, 70, 0);
        guiItemStacks.init(1, true, 110, 0);
        guiItemStacks.set(0, new ItemStack((IItemProvider)Items.field_151131_as));
        guiItemStacks.set(1, Arrays.asList(new ItemStack((IItemProvider)Items.field_151129_at), null));
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiFluidStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                tooltip.add(new StringTextComponent(slotIndex + " Input fluidStack"));
            } else {
                tooltip.add(new StringTextComponent(slotIndex + " Output fluidStack"));
            }
        });
        guiFluidStacks.init(0, false, 90, 0, 16, 58, 16000, false, this.tankOverlay);
        guiFluidStacks.init(1, true, 24, 0, 12, 47, 2000, true, null);
        guiFluidStacks.setBackground(0, this.tankBackground);
        List<List<FluidStack>> fluidInputs = ingredients.getInputs(VanillaTypes.FLUID);
        guiFluidStacks.set(0, fluidInputs.get(0));
        guiFluidStacks.set(1, fluidInputs.get(1));
        IGuiIngredientGroup<DebugIngredient> debugIngredientsGroup = recipeLayout.getIngredientsGroup(DebugIngredient.TYPE);
        debugIngredientsGroup.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                tooltip.add(new StringTextComponent(slotIndex + " Input DebugIngredient"));
            } else {
                tooltip.add(new StringTextComponent(slotIndex + " Output DebugIngredient"));
            }
        });
        debugIngredientsGroup.init(0, true, 40, 0);
        debugIngredientsGroup.init(1, false, 40, 16);
        debugIngredientsGroup.init(2, false, 40, 32);
        debugIngredientsGroup.set(ingredients);
    }

    @Override
    public List<ITextComponent> getTooltipStrings(DebugRecipe recipe, double mouseX, double mouseY) {
        ArrayList<ITextComponent> tooltipStrings = new ArrayList<ITextComponent>();
        tooltipStrings.add((ITextComponent)new StringTextComponent("Debug Recipe Category Tooltip"));
        if (recipe.checkHover(mouseX, mouseY)) {
            tooltipStrings.add((ITextComponent)new StringTextComponent("button tooltip!"));
        } else {
            StringTextComponent debug = new StringTextComponent("tooltip debug");
            tooltipStrings.add((ITextComponent)debug.func_240699_a_(TextFormatting.BOLD));
        }
        tooltipStrings.add((ITextComponent)new StringTextComponent(mouseX + ", " + mouseY));
        return tooltipStrings;
    }

    @Override
    public boolean handleClick(DebugRecipe recipe, double mouseX, double mouseY, int mouseButton) {
        ExtendedButton button = recipe.getButton();
        if (mouseButton == 0 && button.func_231044_a_(mouseX, mouseY, mouseButton)) {
            IJeiRuntime runtime;
            Minecraft minecraft = Minecraft.func_71410_x();
            ClientPlayerEntity player = minecraft.field_71439_g;
            if (player != null) {
                InventoryScreen screen = new InventoryScreen((PlayerEntity)player);
                minecraft.func_147108_a((Screen)screen);
            }
            if ((runtime = JeiDebugPlugin.jeiRuntime) != null) {
                IIngredientFilter ingredientFilter = runtime.getIngredientFilter();
                String filterText = ingredientFilter.getFilterText();
                ingredientFilter.setFilterText(filterText + " test");
                IRecipeManager recipeManager = runtime.getRecipeManager();
                if (!this.hiddenRecipes) {
                    recipeManager.hideRecipeCategory(VanillaRecipeCategoryUid.CRAFTING);
                    this.hiddenRecipes = true;
                } else {
                    recipeManager.unhideRecipeCategory(VanillaRecipeCategoryUid.CRAFTING);
                    this.hiddenRecipes = false;
                }
            }
            return true;
        }
        return false;
    }
}

