/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.SearchMode;
import mezz.jei.events.EditModeToggleEvent;
import mezz.jei.events.EventBusHelper;
import mezz.jei.events.PlayerJoinedWorldEvent;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.ingredients.IIngredientListElementInfo;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientListElementComparator;
import mezz.jei.ingredients.IngredientListElementInfo;
import mezz.jei.search.ElementSearch;
import mezz.jei.search.ElementSearchLowMem;
import mezz.jei.search.IElementSearch;
import mezz.jei.search.PrefixInfo;
import mezz.jei.util.Translator;
import net.minecraft.util.NonNullList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientFilter
implements IIngredientGridSource {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern FILTER_SPLIT_PATTERN = Pattern.compile("(-?\".*?(?:\"|$)|\\S+)");
    private final IngredientBlacklistInternal blacklist;
    private final IEditModeConfig editModeConfig;
    private final IIngredientManager ingredientManager;
    private final IElementSearch elementSearch;
    private final Char2ObjectMap<PrefixInfo> prefixInfos = new Char2ObjectOpenHashMap();
    @Nullable
    private String filterCached;
    private List<IIngredientListElement<?>> ingredientListCached = Collections.emptyList();
    private final List<IIngredientGridSource.Listener> listeners = new ArrayList<IIngredientGridSource.Listener>();

    public IngredientFilter(IngredientBlacklistInternal blacklist, IClientConfig clientConfig, IIngredientFilterConfig config, IEditModeConfig editModeConfig, IIngredientManager ingredientManager) {
        this.blacklist = blacklist;
        this.editModeConfig = editModeConfig;
        this.ingredientManager = ingredientManager;
        this.elementSearch = clientConfig.isLowMemorySlowSearchEnabled() ? new ElementSearchLowMem() : new ElementSearch();
        this.prefixInfos.put('@', (Object)new PrefixInfo(config::getModNameSearchMode, IIngredientListElementInfo::getModNameStrings));
        this.prefixInfos.put('#', (Object)new PrefixInfo(config::getTooltipSearchMode, e -> e.getTooltipStrings(config, ingredientManager)));
        this.prefixInfos.put('$', (Object)new PrefixInfo(config::getTagSearchMode, e -> e.getTagStrings(ingredientManager)));
        this.prefixInfos.put('%', (Object)new PrefixInfo(config::getCreativeTabSearchMode, e -> e.getCreativeTabsStrings(ingredientManager)));
        this.prefixInfos.put('^', (Object)new PrefixInfo(config::getColorSearchMode, e -> e.getColorStrings(ingredientManager)));
        this.prefixInfos.put('&', (Object)new PrefixInfo(config::getResourceIdSearchMode, element -> Collections.singleton(element.getResourceId())));
        for (PrefixInfo prefixInfo : this.prefixInfos.values()) {
            this.elementSearch.registerPrefix(prefixInfo);
        }
        EventBusHelper.addListener(EditModeToggleEvent.class, editModeToggleEvent -> {
            this.filterCached = null;
            this.updateHidden();
        });
        EventBusHelper.addListener(PlayerJoinedWorldEvent.class, playerJoinedWorldEvent -> {
            this.filterCached = null;
            this.updateHidden();
        });
    }

    public void addIngredients(NonNullList<IIngredientListElement<?>> ingredients, IIngredientManager ingredientManager, IModIdHelper modIdHelper) {
        List ingredientInfo = ingredients.stream().map(i -> IngredientListElementInfo.create(i, ingredientManager, modIdHelper)).sorted(IngredientListElementComparator.INSTANCE).collect(Collectors.toList());
        String currentModName = null;
        for (IIngredientListElementInfo element : ingredientInfo) {
            String modname = element.getModNameForSorting();
            if (!Objects.equals(currentModName, modname)) {
                currentModName = modname;
                LOGGER.debug("Indexing ingredients: " + modname);
            }
            this.addIngredient(element);
        }
    }

    public <V> void addIngredient(IIngredientListElementInfo<V> info) {
        IIngredientListElement<V> element = info.getElement();
        this.updateHiddenState(element);
        this.elementSearch.add(info);
        this.invalidateCache();
    }

    public void invalidateCache() {
        this.filterCached = null;
    }

    public <V> List<IIngredientListElementInfo<V>> findMatchingElements(IIngredientHelper<V> ingredientHelper, V ingredient) {
        String ingredientUid = ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
        String displayName = ingredientHelper.getDisplayName(ingredient);
        Class<?> ingredientClass = ingredient.getClass();
        ArrayList<IIngredientListElementInfo<V>> matchingElements = new ArrayList<IIngredientListElementInfo<V>>();
        IntSet matchingIndexes = this.elementSearch.getSearchResults(Translator.toLowercaseWithLocale(displayName), PrefixInfo.NO_PREFIX);
        if (matchingIndexes == null) {
            return matchingElements;
        }
        IntIterator iterator = matchingIndexes.iterator();
        while (iterator.hasNext()) {
            Object castMatchingIngredient;
            String matchingUid;
            int index = iterator.nextInt();
            IIngredientListElementInfo matchingElementInfo = this.elementSearch.get(index);
            Object matchingIngredient = matchingElementInfo.getElement().getIngredient();
            if (!ingredientClass.isInstance(matchingIngredient) || !ingredientUid.equals(matchingUid = ingredientHelper.getUniqueId(castMatchingIngredient = ingredientClass.cast(matchingIngredient), UidContext.Ingredient))) continue;
            IIngredientListElementInfo matchingElementInfoCast = matchingElementInfo;
            matchingElements.add(matchingElementInfoCast);
        }
        return matchingElements;
    }

    public void modesChanged() {
        this.elementSearch.start();
        this.filterCached = null;
    }

    public void updateHidden() {
        for (IIngredientListElementInfo<?> info : this.elementSearch.getAllIngredients()) {
            IIngredientListElement<?> element = info.getElement();
            this.updateHiddenState(element);
        }
    }

    public <V> void updateHiddenState(IIngredientListElement<V> element) {
        IIngredientHelper<V> ingredientHelper;
        boolean visible;
        V ingredient = element.getIngredient();
        boolean bl = visible = !this.blacklist.isIngredientBlacklistedByApi(ingredient, ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient)) && ingredientHelper.isIngredientOnServer(ingredient) && (this.editModeConfig.isEditModeEnabled() || !this.editModeConfig.isIngredientOnConfigBlacklist(ingredient, ingredientHelper));
        if (element.isVisible() != visible) {
            element.setVisible(visible);
            this.filterCached = null;
        }
    }

    @Override
    public List<IIngredientListElement<?>> getIngredientList(String filterText) {
        if (!(filterText = filterText.toLowerCase()).equals(this.filterCached)) {
            List<IIngredientListElementInfo<?>> ingredientList = this.getIngredientListUncached(filterText);
            this.ingredientListCached = ingredientList.stream().map(IIngredientListElementInfo::getElement).collect(Collectors.toList());
            this.filterCached = filterText;
        }
        return this.ingredientListCached;
    }

    public ImmutableList<Object> getFilteredIngredients(String filterText) {
        List<IIngredientListElement<?>> elements = this.getIngredientList(filterText);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IIngredientListElement<?> element : elements) {
            Object ingredient = element.getIngredient();
            builder.add(ingredient);
        }
        return builder.build();
    }

    private List<IIngredientListElementInfo<?>> getIngredientListUncached(String filterText) {
        String[] filters = filterText.split("\\|");
        IntSet matches = null;
        for (String filter : filters) {
            IntSet elements = this.getElements(filter);
            if (elements == null) continue;
            if (matches == null) {
                matches = elements;
                continue;
            }
            matches.addAll((IntCollection)elements);
        }
        if (matches == null) {
            return this.elementSearch.getAllIngredients().parallelStream().filter(info -> {
                IIngredientListElement element = info.getElement();
                return element.isVisible();
            }).collect(Collectors.toList());
        }
        ArrayList matchingIngredients = new ArrayList();
        int[] matchesList = matches.toIntArray();
        Arrays.sort(matchesList);
        for (int match : matchesList) {
            IIngredientListElementInfo info2 = this.elementSearch.get(match);
            IIngredientListElement element = info2.getElement();
            if (!element.isVisible()) continue;
            matchingIngredients.add(info2);
        }
        return matchingIngredients;
    }

    public <T> List<IIngredientListElementInfo<T>> getMatches(T ingredient, IIngredientHelper<T> ingredientHelper, Function<T, String> uidFunction) {
        String uid = uidFunction.apply(ingredient);
        Class<?> ingredientClass = ingredient.getClass();
        List<IIngredientListElementInfo<T>> matchingElements = this.findMatchingElements(ingredientHelper, ingredient);
        IntOpenHashSet matchingIndexes = new IntOpenHashSet(50);
        IntOpenHashSet startingIndexes = new IntOpenHashSet(matchingElements.size());
        for (IIngredientListElementInfo<T> matchingElement : matchingElements) {
            int index = this.elementSearch.indexOf(matchingElement);
            startingIndexes.add(index);
            matchingIndexes.add(index);
        }
        IntIterator iterator = startingIndexes.iterator();
        while (iterator.hasNext()) {
            String elementWildcardId;
            IIngredientListElementInfo info;
            Object elementIngredient;
            int i;
            int startingIndex = iterator.nextInt();
            for (i = startingIndex - 1; i >= 0 && !matchingIndexes.contains(i) && (elementIngredient = (info = this.elementSearch.get(i)).getElement().getIngredient()).getClass() == ingredientClass && uid.equals(elementWildcardId = uidFunction.apply(ingredientClass.cast(elementIngredient))); --i) {
                matchingIndexes.add(i);
                IIngredientListElementInfo castInfo = info;
                matchingElements.add(castInfo);
            }
            for (i = startingIndex + 1; i < this.elementSearch.size() && !matchingIndexes.contains(i) && (elementIngredient = (info = this.elementSearch.get(i)).getElement().getIngredient()).getClass() == ingredientClass && uid.equals(elementWildcardId = uidFunction.apply(ingredientClass.cast(elementIngredient))); ++i) {
                matchingIndexes.add(i);
                IIngredientListElementInfo castElement = info;
                matchingElements.add(castElement);
            }
        }
        return matchingElements;
    }

    @Nullable
    private IntSet getElements(String filterText) {
        Matcher filterMatcher = FILTER_SPLIT_PATTERN.matcher(filterText);
        IntSet matches = null;
        IntSet removeMatches = null;
        while (filterMatcher.find()) {
            IntSet searchResults;
            String token = filterMatcher.group(1);
            boolean remove = token.startsWith("-");
            if (remove) {
                token = token.substring(1);
            }
            if ((searchResults = this.getSearchResults(token = QUOTE_PATTERN.matcher(token).replaceAll(""))) == null) continue;
            if (remove) {
                if (removeMatches == null) {
                    removeMatches = searchResults;
                    continue;
                }
                removeMatches.addAll((IntCollection)searchResults);
                continue;
            }
            if (!(matches = matches == null ? searchResults : IngredientFilter.intersection(matches, searchResults)).isEmpty()) continue;
            break;
        }
        if (matches != null && removeMatches != null) {
            matches.removeAll(removeMatches);
        }
        return matches;
    }

    @Nullable
    private IntSet getSearchResults(String token) {
        if (token.isEmpty()) {
            return null;
        }
        char firstChar = token.charAt(0);
        PrefixInfo prefixInfo = (PrefixInfo)this.prefixInfos.get(firstChar);
        if (prefixInfo != null && prefixInfo.getMode() != SearchMode.DISABLED) {
            if ((token = token.substring(1)).isEmpty()) {
                return null;
            }
            return this.elementSearch.getSearchResults(token, prefixInfo);
        }
        return this.elementSearch.getSearchResults(token, PrefixInfo.NO_PREFIX);
    }

    private static IntSet intersection(IntSet set1, IntSet set2) {
        if (set1.size() > set2.size()) {
            set2.retainAll((IntCollection)set1);
            return set2;
        }
        set1.retainAll((IntCollection)set2);
        return set1;
    }

    @Override
    public void addListener(IIngredientGridSource.Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListenersOfChange() {
        for (IIngredientGridSource.Listener listener : this.listeners) {
            listener.onChange();
        }
    }
}

