/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableBlank;
import mezz.jei.gui.elements.GuiIconButton;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiIconToggleButton {
    private final IDrawable offIcon;
    private final IDrawable onIcon;
    private final GuiIconButton button;
    private final HoverChecker hoverChecker;

    public GuiIconToggleButton(IDrawable offIcon, IDrawable onIcon) {
        this.offIcon = offIcon;
        this.onIcon = onIcon;
        this.button = new GuiIconButton(new DrawableBlank(0, 0), b -> {});
        this.hoverChecker = new HoverChecker();
        this.hoverChecker.updateBounds(this.button);
    }

    public void updateBounds(Rectangle2d area) {
        this.button.func_230991_b_(area.func_199316_c());
        this.button.setHeight(area.func_199317_d());
        this.button.field_230690_l_ = area.func_199318_a();
        this.button.field_230691_m_ = area.func_199319_b();
        this.hoverChecker.updateBounds(this.button);
    }

    public void draw(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        IDrawable icon = this.isIconToggledOn() ? this.onIcon : this.offIcon;
        icon.draw(matrixStack, this.button.field_230690_l_ + 2, this.button.field_230691_m_ + 2);
    }

    public final boolean isMouseOver(double mouseX, double mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public final boolean handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        return this.button.func_231044_a_(mouseX, mouseY, mouseButton) && this.onMouseClicked(mouseX, mouseY, mouseButton);
    }

    public final void drawTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            this.getTooltips(tooltip);
            TooltipRenderer.drawHoveringText(tooltip, mouseX, mouseY, 150, matrixStack);
        }
    }

    protected abstract void getTooltips(List<ITextComponent> var1);

    protected abstract boolean isIconToggledOn();

    protected abstract boolean onMouseClicked(double var1, double var3, int var5);
}

