/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import mezz.jei.Internal;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.gui.textures.Textures;
import mezz.jei.input.IPaged;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Rectangle2d;

public class PageNavigation {
    private final IPaged paged;
    private final GuiIconButton nextButton;
    private final GuiIconButton backButton;
    private final boolean hideOnSinglePage;
    private String pageNumDisplayString = "1/1";
    private int pageNumDisplayX;
    private int pageNumDisplayY;

    public PageNavigation(IPaged paged, boolean hideOnSinglePage) {
        this.paged = paged;
        Textures textures = Internal.getTextures();
        this.nextButton = new GuiIconButton(textures.getArrowNext(), b -> paged.nextPage());
        this.backButton = new GuiIconButton(textures.getArrowPrevious(), b -> paged.previousPage());
        this.hideOnSinglePage = hideOnSinglePage;
    }

    public void updateBounds(Rectangle2d area) {
        int buttonSize = area.func_199317_d();
        this.nextButton.field_230690_l_ = area.func_199318_a() + area.func_199316_c() - buttonSize;
        this.nextButton.field_230691_m_ = area.func_199319_b();
        this.nextButton.func_230991_b_(buttonSize);
        this.nextButton.setHeight(buttonSize);
        this.backButton.field_230690_l_ = area.func_199318_a();
        this.backButton.field_230691_m_ = area.func_199319_b();
        this.backButton.func_230991_b_(buttonSize);
        this.backButton.setHeight(buttonSize);
    }

    public void updatePageState() {
        int pageNum = this.paged.getPageNumber();
        int pageCount = this.paged.getPageCount();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.pageNumDisplayString = pageNum + 1 + "/" + pageCount;
        int pageDisplayWidth = fontRenderer.func_78256_a(this.pageNumDisplayString);
        this.pageNumDisplayX = (this.backButton.field_230690_l_ + this.backButton.func_230998_h_() + this.nextButton.field_230690_l_) / 2 - pageDisplayWidth / 2;
        int n = this.backButton.field_230691_m_;
        int n2 = this.backButton.func_238483_d_();
        fontRenderer.getClass();
        this.pageNumDisplayY = n + Math.round((float)(n2 - 9) / 2.0f);
    }

    public void draw(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.hideOnSinglePage || this.paged.hasNext() || this.paged.hasPrevious()) {
            minecraft.field_71466_p.func_238405_a_(matrixStack, this.pageNumDisplayString, (float)this.pageNumDisplayX, (float)this.pageNumDisplayY, -1);
            this.nextButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.backButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.nextButton.func_231047_b_(mouseX, mouseY) || this.backButton.func_231047_b_(mouseX, mouseY);
    }

    public boolean handleMouseClickedButtons(double mouseX, double mouseY, int mouseButton) {
        return this.nextButton.func_231044_a_(mouseX, mouseY, mouseButton) || this.backButton.func_231044_a_(mouseX, mouseY, mouseButton);
    }
}

