/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientRenderHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static <V> List<String> getIngredientTooltipSafe(V ingredient, IIngredientRenderer<V> ingredientRenderer, IIngredientHelper<V> ingredientHelper, IModIdHelper modIdHelper) {
        try {
            Minecraft minecraft = Minecraft.func_71410_x();
            ITooltipFlag.TooltipFlags tooltipFlag = minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            List<String> tooltip = ingredientRenderer.getTooltip(ingredient, (ITooltipFlag)tooltipFlag);
            tooltip = modIdHelper.addModNameToIngredientTooltip(tooltip, ingredient, ingredientHelper);
            return tooltip;
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Tooltip crashed.", e);
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(TextFormatting.RED + Translator.translateToLocal("jei.tooltip.error.crash"));
            return tooltip;
        }
    }
}

