/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.SmokingRecipe;
import net.minecraft.util.NonNullList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VanillaRecipeValidator {
    private static final Logger LOGGER = LogManager.getLogger();

    private VanillaRecipeValidator() {
    }

    public static Results getValidRecipes(IRecipeCategory<ICraftingRecipe> craftingCategory, IRecipeCategory<FurnaceRecipe> furnaceCategory, IRecipeCategory<SmokingRecipe> smokingCategory, IRecipeCategory<BlastingRecipe> blastingCategory, IRecipeCategory<CampfireCookingRecipe> campfireCategory) {
        CategoryRecipeValidator<ICraftingRecipe> craftingRecipesValidator = new CategoryRecipeValidator<ICraftingRecipe>(craftingCategory, 9);
        CategoryRecipeValidator<FurnaceRecipe> furnaceRecipesValidator = new CategoryRecipeValidator<FurnaceRecipe>(furnaceCategory, 1);
        CategoryRecipeValidator<SmokingRecipe> smokingRecipesValidator = new CategoryRecipeValidator<SmokingRecipe>(smokingCategory, 1);
        CategoryRecipeValidator<BlastingRecipe> blastingRecipesValidator = new CategoryRecipeValidator<BlastingRecipe>(blastingCategory, 1);
        CategoryRecipeValidator<CampfireCookingRecipe> campfireRecipesValidator = new CategoryRecipeValidator<CampfireCookingRecipe>(campfireCategory, 1);
        Results results = new Results();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RecipeManager recipeManager = world.func_199532_z();
        for (ICraftingRecipe recipe : VanillaRecipeValidator.getRecipes(recipeManager, IRecipeType.field_222149_a)) {
            if (!craftingRecipesValidator.isRecipeValid(recipe)) continue;
            results.craftingRecipes.add(recipe);
        }
        for (ICraftingRecipe recipe : VanillaRecipeValidator.getRecipes(recipeManager, IRecipeType.field_222150_b)) {
            if (!furnaceRecipesValidator.isRecipeValid((FurnaceRecipe)recipe)) continue;
            results.furnaceRecipes.add(recipe);
        }
        for (ICraftingRecipe recipe : VanillaRecipeValidator.getRecipes(recipeManager, IRecipeType.field_222152_d)) {
            if (!smokingRecipesValidator.isRecipeValid((SmokingRecipe)recipe)) continue;
            results.smokingRecipes.add(recipe);
        }
        for (ICraftingRecipe recipe : VanillaRecipeValidator.getRecipes(recipeManager, IRecipeType.field_222151_c)) {
            if (!blastingRecipesValidator.isRecipeValid((BlastingRecipe)recipe)) continue;
            results.blastingRecipes.add(recipe);
        }
        for (ICraftingRecipe recipe : VanillaRecipeValidator.getRecipes(recipeManager, IRecipeType.field_222153_e)) {
            if (!campfireRecipesValidator.isRecipeValid((CampfireCookingRecipe)recipe)) continue;
            results.campfireRecipes.add(recipe);
        }
        return results;
    }

    private static <C extends IInventory, T extends IRecipe<C>> Collection<T> getRecipes(RecipeManager recipeManager, IRecipeType<T> recipeType) {
        Map recipesMap = recipeManager.func_215366_a(recipeType);
        return recipesMap.values();
    }

    private static final class CategoryRecipeValidator<T extends IRecipe<?>> {
        private static final int INVALID_COUNT = -1;
        private final IRecipeCategory<T> recipeCategory;
        private final int maxInputs;

        public CategoryRecipeValidator(IRecipeCategory<T> recipeCategory, int maxInputs) {
            this.recipeCategory = recipeCategory;
            this.maxInputs = maxInputs;
        }

        public boolean isRecipeValid(T recipe) {
            if (recipe.func_192399_d()) {
                return false;
            }
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput == null || recipeOutput.func_190926_b()) {
                String recipeInfo = this.getInfo(recipe);
                LOGGER.error("Recipe has no output. {}", (Object)recipeInfo);
                return false;
            }
            NonNullList ingredients = recipe.func_192400_c();
            if (ingredients == null) {
                String recipeInfo = this.getInfo(recipe);
                LOGGER.error("Recipe has no input Ingredients. {}", (Object)recipeInfo);
                return false;
            }
            int inputCount = CategoryRecipeValidator.getInputCount((List<Ingredient>)ingredients);
            if (inputCount == -1) {
                return false;
            }
            if (inputCount > this.maxInputs) {
                String recipeInfo = this.getInfo(recipe);
                LOGGER.error("Recipe has too many inputs. {}", (Object)recipeInfo);
                return false;
            }
            if (inputCount == 0) {
                String recipeInfo = this.getInfo(recipe);
                LOGGER.error("Recipe has no inputs. {}", (Object)recipeInfo);
                return false;
            }
            return true;
        }

        private String getInfo(T recipe) {
            return ErrorUtil.getInfoFromRecipe(recipe, this.recipeCategory);
        }

        protected static int getInputCount(List<Ingredient> ingredientList) {
            int inputCount = 0;
            for (Ingredient ingredient : ingredientList) {
                ItemStack[] input = ingredient.func_193365_a();
                if (input == null) {
                    return -1;
                }
                ++inputCount;
            }
            return inputCount;
        }
    }

    public static class Results {
        private final List<IRecipe> craftingRecipes = new ArrayList<IRecipe>();
        private final List<FurnaceRecipe> furnaceRecipes = new ArrayList<FurnaceRecipe>();
        private final List<SmokingRecipe> smokingRecipes = new ArrayList<SmokingRecipe>();
        private final List<BlastingRecipe> blastingRecipes = new ArrayList<BlastingRecipe>();
        private final List<CampfireCookingRecipe> campfireRecipes = new ArrayList<CampfireCookingRecipe>();

        public List<IRecipe> getCraftingRecipes() {
            return this.craftingRecipes;
        }

        public List<FurnaceRecipe> getFurnaceRecipes() {
            return this.furnaceRecipes;
        }

        public List<SmokingRecipe> getSmokingRecipes() {
            return this.smokingRecipes;
        }

        public List<BlastingRecipe> getBlastingRecipes() {
            return this.blastingRecipes;
        }

        public List<CampfireCookingRecipe> getCampfireRecipes() {
            return this.campfireRecipes;
        }
    }
}

