/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.util.Translator;
import net.minecraftforge.fml.client.config.HoverChecker;

public class ShapelessIcon {
    private static final int scale = 4;
    private final IDrawable icon = Internal.getTextures().getShapelessIcon();
    private final HoverChecker hoverChecker;

    public ShapelessIcon() {
        int iconBottom = this.icon.getHeight() / 4;
        int iconLeft = 116 - this.icon.getWidth() / 4;
        int iconRight = iconLeft + this.icon.getWidth() / 4;
        this.hoverChecker = new HoverChecker(0, iconBottom, iconLeft, iconRight, 0);
    }

    public void draw(int recipeWidth) {
        int shapelessIconX = recipeWidth - this.icon.getWidth() / 4;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)shapelessIconX, (float)0.0f, (float)0.0f);
        RenderSystem.scaled((double)0.25, (double)0.25, (double)1.0);
        this.icon.draw();
        RenderSystem.popMatrix();
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (this.hoverChecker.checkHover(mouseX, mouseY)) {
            return Collections.singletonList(Translator.translateToLocal("jei.tooltip.shapeless.recipe"));
        }
        return null;
    }
}

