/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import javax.annotation.Nullable;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.util.ErrorUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class StackHelper
implements IStackHelper {
    private final ISubtypeManager subtypeManager;

    public StackHelper(ISubtypeManager subtypeManager) {
        this.subtypeManager = subtypeManager;
    }

    @Override
    public boolean isEquivalent(@Nullable ItemStack lhs, @Nullable ItemStack rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.func_77973_b() != rhs.func_77973_b()) {
            return false;
        }
        String keyLhs = this.getUniqueIdentifierForStack(lhs, UidMode.NORMAL);
        String keyRhs = this.getUniqueIdentifierForStack(rhs, UidMode.NORMAL);
        return keyLhs.equals(keyRhs);
    }

    public String getUniqueIdentifierForStack(ItemStack stack) {
        return this.getUniqueIdentifierForStack(stack, UidMode.NORMAL);
    }

    public String getUniqueIdentifierForStack(ItemStack stack, UidMode mode) {
        String subtypeInfo;
        ErrorUtil.checkNotEmpty(stack, "stack");
        Item item = stack.func_77973_b();
        ResourceLocation registryName = item.getRegistryName();
        if (registryName == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            throw new IllegalStateException("Item has no registry name: " + stackInfo);
        }
        String result = registryName.toString();
        if (mode == UidMode.NORMAL && (subtypeInfo = this.subtypeManager.getSubtypeInfo(stack)) != null && !subtypeInfo.isEmpty()) {
            result = result + ':' + subtypeInfo;
        }
        return result;
    }

    public static enum UidMode {
        NORMAL,
        WILDCARD;

    }
}

