/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.config.BookmarkConfig;
import mezz.jei.config.ClientConfig;
import mezz.jei.config.HideModeConfig;
import mezz.jei.config.IHideModeConfig;
import mezz.jei.config.IngredientFilterConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.ModIdFormattingConfig;
import mezz.jei.config.WorldConfig;
import mezz.jei.events.EventBusHelper;
import mezz.jei.events.PlayerJoinedWorldEvent;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.textures.JeiTextureMap;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.ForgeModIdHelper;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.startup.JeiStarter;
import mezz.jei.startup.NetworkHandler;
import mezz.jei.util.AnnotatedInstanceUtil;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.network.NetworkManager;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientLifecycleHandler {
    private final Logger LOGGER = LogManager.getLogger();
    private final JeiStarter starter = new JeiStarter();
    private final JeiTextureMap textureMap = new JeiTextureMap("textures");
    @Nullable
    private Textures textures;
    private final ClientConfig clientConfig;
    private final BookmarkConfig bookmarkConfig;
    private final ModIdFormattingConfig modIdFormattingConfig;
    private final IngredientFilterConfig ingredientFilterConfig;
    private final WorldConfig worldConfig;
    private final IModIdHelper modIdHelper;
    private final IHideModeConfig hideModeConfig;

    public ClientLifecycleHandler(NetworkHandler networkHandler) {
        File jeiConfigurationDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "jei");
        if (!jeiConfigurationDir.exists()) {
            try {
                if (!jeiConfigurationDir.mkdir()) {
                    throw new RuntimeException("Could not create config directory " + jeiConfigurationDir);
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException("Could not create config directory " + jeiConfigurationDir, e);
            }
        }
        this.clientConfig = new ClientConfig(jeiConfigurationDir);
        this.bookmarkConfig = new BookmarkConfig(jeiConfigurationDir);
        this.worldConfig = new WorldConfig(jeiConfigurationDir);
        this.ingredientFilterConfig = new IngredientFilterConfig(this.clientConfig.getConfig());
        this.modIdFormattingConfig = new ModIdFormattingConfig(this.clientConfig.getConfig());
        this.modIdHelper = new ForgeModIdHelper(this.clientConfig, this.modIdFormattingConfig);
        ErrorUtil.setModIdHelper(this.modIdHelper);
        this.hideModeConfig = new HideModeConfig(jeiConfigurationDir);
        KeyBindings.init();
        this.clientConfig.onPreInit();
        EventBusHelper.addListener(ConfigChangedEvent.OnConfigChangedEvent.class, event -> {
            this.modIdFormattingConfig.checkForModNameFormatOverride();
            if ("jei".equals(event.getModID())) {
                JeiRuntime runtime;
                if (this.clientConfig.syncAllConfig()) {
                    // empty if block
                }
                if (this.ingredientFilterConfig.syncConfig() && (runtime = Internal.getRuntime()) != null) {
                    IngredientListOverlay ingredientListOverlay = runtime.getIngredientListOverlay();
                    ingredientListOverlay.rebuildIngredientFilter();
                }
                if (this.worldConfig.syncConfig()) {
                    // empty if block
                }
            }
        });
        EventBusHelper.addListener(WorldEvent.Save.class, event -> this.worldConfig.onWorldSave());
        EventBusHelper.addListener(TextureStitchEvent.Pre.class, event -> {
            this.textures = new Textures(this.textureMap);
        });
        EventBusHelper.addListener(RecipesUpdatedEvent.class, event -> {
            NetHandlerPlayClient connection = Minecraft.func_71410_x().func_147114_u();
            if (connection != null) {
                NetworkManager networkManager = connection.func_147298_b();
                this.worldConfig.syncWorldConfig(networkManager);
            }
            this.onRecipesLoaded();
            EventBusHelper.post(new PlayerJoinedWorldEvent());
        });
        networkHandler.createClientPacketHandler(this.worldConfig);
    }

    public void onLoadComplete() {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_152344_a(() -> minecraft.field_71446_o.func_110580_a(this.textureMap.getLocation(), (ITickableTextureObject)this.textureMap));
    }

    private void onRecipesLoaded() {
        this.modIdFormattingConfig.checkForModNameFormatOverride();
        List<IModPlugin> plugins = AnnotatedInstanceUtil.getModPlugins();
        Minecraft minecraft = Minecraft.func_71410_x();
        IReloadableResourceManager reloadableResourceManager = (IReloadableResourceManager)minecraft.func_195551_G();
        reloadableResourceManager.func_199006_a(resourceManager -> {
            if (this.starter.hasStarted()) {
                this.LOGGER.info("Restarting JEI.");
                Preconditions.checkNotNull((Object)this.textures);
                this.starter.start(plugins, this.textures, this.clientConfig, this.hideModeConfig, this.ingredientFilterConfig, this.worldConfig, this.bookmarkConfig, this.modIdHelper);
            }
        });
        Preconditions.checkNotNull((Object)this.textures);
        this.starter.start(plugins, this.textures, this.clientConfig, this.hideModeConfig, this.ingredientFilterConfig, this.worldConfig, this.bookmarkConfig, this.modIdHelper);
    }
}

