/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import javax.annotation.Nullable;
import mezz.jei.config.IHideModeConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.client.ForgeHooksClient;

public class ItemStackFastRenderer
extends IngredientListElementRenderer<ItemStack> {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    public ItemStackFastRenderer(IIngredientListElement<ItemStack> itemStackElement) {
        super(itemStackElement);
    }

    public void renderItemAndEffectIntoGUI(IHideModeConfig hideModeConfig, IWorldConfig worldConfig) {
        try {
            this.uncheckedRenderItemAndEffectIntoGUI(hideModeConfig, worldConfig);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, this.element.getIngredient());
        }
    }

    @Nullable
    private IBakedModel getBakedModel() {
        ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        IBakedModel bakedModel = itemModelMesher.func_178089_a(itemStack);
        return bakedModel.func_188617_f().func_209581_a(bakedModel, itemStack, null, null);
    }

    private void uncheckedRenderItemAndEffectIntoGUI(IHideModeConfig hideModeConfig, IWorldConfig worldConfig) {
        if (worldConfig.isHideModeEnabled()) {
            this.renderEditMode(this.area, this.padding, hideModeConfig);
            GlStateManager.func_179147_l();
        }
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        IBakedModel bakedModel = this.getBakedModel();
        if (bakedModel == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)(this.area.func_199318_a() + this.padding) + 8.0f), (float)((float)(this.area.func_199319_b() + this.padding) + 8.0f), (float)150.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)-16.0f, (float)16.0f);
        bakedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedModel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Minecraft minecraft = Minecraft.func_71410_x();
        ItemRenderer itemRenderer = minecraft.func_175599_af();
        itemRenderer.func_191961_a(bakedModel, itemStack);
        if (itemStack.func_77962_s()) {
            this.renderEffect(bakedModel);
        }
        GlStateManager.func_179121_F();
    }

    protected void renderEffect(IBakedModel model) {
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureManager textureManager = minecraft.func_110434_K();
        ItemRenderer itemRenderer = minecraft.func_175599_af();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        textureManager.func_110577_a(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Util.func_211177_b() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        itemRenderer.func_191965_a(model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Util.func_211177_b() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        itemRenderer.func_191965_a(model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        textureManager.func_110577_a(TextureMap.field_110575_b);
    }

    public void renderOverlay() {
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        try {
            this.renderOverlay(itemStack, this.area, this.padding);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, this.element.getIngredient());
        }
    }

    private void renderOverlay(ItemStack itemStack, Rectangle2d area, int padding) {
        FontRenderer font = ItemStackFastRenderer.getFontRenderer(itemStack);
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        itemRenderer.func_180453_a(font, itemStack, area.func_199318_a() + padding, area.func_199319_b() + padding, null);
    }

    public static FontRenderer getFontRenderer(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        FontRenderer fontRenderer = item.getFontRenderer(itemStack);
        if (fontRenderer == null) {
            fontRenderer = Minecraft.func_71410_x().field_71466_p;
        }
        return fontRenderer;
    }
}

