/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.ISlowRenderItem;
import mezz.jei.config.IHideModeConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.render.ItemStackFastRenderer;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientListBatchRenderer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<IngredientListSlot> slots = new ArrayList<IngredientListSlot>();
    private final List<ItemStackFastRenderer> renderItems2d = new ArrayList<ItemStackFastRenderer>();
    private final List<ItemStackFastRenderer> renderItems3d = new ArrayList<ItemStackFastRenderer>();
    private final List<IngredientListElementRenderer> renderOther = new ArrayList<IngredientListElementRenderer>();
    private final IHideModeConfig hideModeConfig;
    private final IWorldConfig worldConfig;
    private int blocked = 0;

    public IngredientListBatchRenderer(IHideModeConfig hideModeConfig, IWorldConfig worldConfig) {
        this.hideModeConfig = hideModeConfig;
        this.worldConfig = worldConfig;
    }

    public void clear() {
        this.slots.clear();
        this.renderItems2d.clear();
        this.renderItems3d.clear();
        this.renderOther.clear();
        this.blocked = 0;
    }

    public int size() {
        return this.slots.size() - this.blocked;
    }

    public void add(IngredientListSlot ingredientListSlot) {
        this.slots.add(ingredientListSlot);
    }

    public List<IngredientListSlot> getAllGuiIngredientSlots() {
        return this.slots;
    }

    public void set(int startIndex, List<IIngredientListElement<?>> ingredientList) {
        this.renderItems2d.clear();
        this.renderItems3d.clear();
        this.renderOther.clear();
        this.blocked = 0;
        int i = startIndex;
        for (IngredientListSlot ingredientListSlot : this.slots) {
            if (ingredientListSlot.isBlocked()) {
                ingredientListSlot.clear();
                ++this.blocked;
                continue;
            }
            if (i >= ingredientList.size()) {
                ingredientListSlot.clear();
            } else {
                IIngredientListElement<?> element = ingredientList.get(i);
                this.set(ingredientListSlot, element);
            }
            ++i;
        }
    }

    private <V> void set(IngredientListSlot ingredientListSlot, IIngredientListElement<V> element) {
        ingredientListSlot.clear();
        V ingredient = element.getIngredient();
        if (ingredient instanceof ItemStack) {
            IBakedModel bakedModel;
            IIngredientListElement<ItemStack> itemStackElement = element;
            ItemStack itemStack = (ItemStack)itemStackElement.getIngredient();
            ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
            try {
                bakedModel = itemModelMesher.func_178089_a(itemStack);
                bakedModel = bakedModel.func_188617_f().func_209581_a(bakedModel, itemStack, null, null);
                Preconditions.checkNotNull((Object)bakedModel, (Object)"IBakedModel must not be null.");
            }
            catch (Throwable throwable) {
                String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
                LOGGER.error("ItemStack crashed getting IBakedModel. {}", (Object)stackInfo, (Object)throwable);
                return;
            }
            if (!bakedModel.func_188618_c() && !(itemStack.func_77973_b() instanceof ISlowRenderItem)) {
                ItemStackFastRenderer renderer = new ItemStackFastRenderer(itemStackElement);
                ingredientListSlot.setIngredientRenderer(renderer);
                if (bakedModel.func_177556_c()) {
                    this.renderItems3d.add(renderer);
                } else {
                    this.renderItems2d.add(renderer);
                }
                return;
            }
        }
        IngredientListElementRenderer<V> renderer = new IngredientListElementRenderer<V>(element);
        ingredientListSlot.setIngredientRenderer(renderer);
        this.renderOther.add(renderer);
    }

    @Nullable
    public ClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        IngredientListElementRenderer hovered = this.getHovered(mouseX, mouseY);
        if (hovered != null) {
            IIngredientListElement element = hovered.getElement();
            return ClickedIngredient.create(element.getIngredient(), hovered.getArea());
        }
        return null;
    }

    @Nullable
    public IngredientListElementRenderer getHovered(double mouseX, double mouseY) {
        for (IngredientListSlot slot : this.slots) {
            if (!slot.isMouseOver(mouseX, mouseY)) continue;
            return slot.getIngredientRenderer();
        }
        return null;
    }

    public void render(Minecraft minecraft) {
        RenderHelper.func_74520_c();
        ItemRenderer itemRenderer = minecraft.func_175599_af();
        TextureManager textureManager = minecraft.func_110434_K();
        itemRenderer.field_77023_b += 50.0f;
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems3d) {
            itemStackFastRenderer.renderItemAndEffectIntoGUI(this.hideModeConfig, this.worldConfig);
        }
        GlStateManager.func_179140_f();
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems2d) {
            itemStackFastRenderer.renderItemAndEffectIntoGUI(this.hideModeConfig, this.worldConfig);
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        itemRenderer.field_77023_b -= 50.0f;
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems3d) {
            itemStackFastRenderer.renderOverlay();
        }
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems2d) {
            itemStackFastRenderer.renderOverlay();
        }
        GlStateManager.func_179140_f();
        for (IngredientListElementRenderer ingredientListElementRenderer : this.renderOther) {
            ingredientListElementRenderer.renderSlow(this.hideModeConfig, this.worldConfig);
        }
        RenderHelper.func_74518_a();
    }
}

