/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.NonNullList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VanillaRecipeValidator {
    private static final Logger LOGGER = LogManager.getLogger();

    private VanillaRecipeValidator() {
    }

    public static Results getValidRecipes(IRecipeCategory<IRecipe> craftingCategory, IRecipeCategory<FurnaceRecipe> furnaceCategory) {
        CategoryRecipeValidator<IRecipe> craftingRecipesValidator = new CategoryRecipeValidator<IRecipe>(craftingCategory, 9);
        CategoryRecipeValidator<FurnaceRecipe> furnaceRecipesValidator = new CategoryRecipeValidator<FurnaceRecipe>(furnaceCategory, 1);
        Results results = new Results();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        RecipeManager recipeManager = world.func_199532_z();
        for (IRecipe recipe : recipeManager.func_199510_b()) {
            if (recipe instanceof FurnaceRecipe) {
                FurnaceRecipe furnaceRecipe = (FurnaceRecipe)recipe;
                if (!furnaceRecipesValidator.isRecipeValid(furnaceRecipe)) continue;
                results.furnaceRecipes.add(furnaceRecipe);
                continue;
            }
            if (!craftingRecipesValidator.isRecipeValid(recipe)) continue;
            results.craftingRecipes.add(recipe);
        }
        return results;
    }

    private static final class CategoryRecipeValidator<T extends IRecipe> {
        private static final int INVALID_COUNT = -1;
        private final IRecipeCategory<T> recipeCategory;
        private final int maxInputs;

        public CategoryRecipeValidator(IRecipeCategory<T> recipeCategory, int maxInputs) {
            this.recipeCategory = recipeCategory;
            this.maxInputs = maxInputs;
        }

        public boolean isRecipeValid(T recipe) {
            if (recipe.func_192399_d()) {
                return false;
            }
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput == null || recipeOutput.func_190926_b()) {
                String recipeInfo = this.getInfo(recipe);
                LOGGER.error("Recipe has no output. {}", (Object)recipeInfo);
                return false;
            }
            NonNullList ingredients = recipe.func_192400_c();
            if (ingredients == null) {
                String recipeInfo = this.getInfo(recipe);
                LOGGER.error("Recipe has no input Ingredients. {}", (Object)recipeInfo);
                return false;
            }
            int inputCount = CategoryRecipeValidator.getInputCount((List<Ingredient>)ingredients);
            if (inputCount == -1) {
                return false;
            }
            if (inputCount > this.maxInputs) {
                String recipeInfo = this.getInfo(recipe);
                LOGGER.error("Recipe has too many inputs. {}", (Object)recipeInfo);
                return false;
            }
            if (inputCount == 0) {
                String recipeInfo = this.getInfo(recipe);
                LOGGER.error("Recipe has no inputs. {}", (Object)recipeInfo);
                return false;
            }
            return true;
        }

        private String getInfo(T recipe) {
            return ErrorUtil.getInfoFromRecipe(recipe, this.recipeCategory);
        }

        protected static int getInputCount(List<Ingredient> ingredientList) {
            int inputCount = 0;
            for (Ingredient ingredient : ingredientList) {
                ItemStack[] input = ingredient.func_193365_a();
                if (input == null) {
                    return -1;
                }
                ++inputCount;
            }
            return inputCount;
        }
    }

    public static class Results {
        private final List<IRecipe> craftingRecipes = new ArrayList<IRecipe>();
        private final List<FurnaceRecipe> furnaceRecipes = new ArrayList<FurnaceRecipe>();

        public List<IRecipe> getCraftingRecipes() {
            return this.craftingRecipes;
        }

        public List<FurnaceRecipe> getFurnaceRecipes() {
            return this.furnaceRecipes;
        }
    }
}

