/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.brewing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeUtil;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BrewingRecipeMaker {
    private final Set<Class> unhandledRecipeClasses = new HashSet<Class>();
    private final Set<IJeiBrewingRecipe> disabledRecipes = new HashSet<IJeiBrewingRecipe>();
    private final IIngredientManager ingredientManager;
    private final IVanillaRecipeFactory vanillaRecipeFactory;

    public static List<IJeiBrewingRecipe> getBrewingRecipes(IIngredientManager ingredientManager, IVanillaRecipeFactory vanillaRecipeFactory) {
        BrewingRecipeMaker brewingRecipeMaker = new BrewingRecipeMaker(ingredientManager, vanillaRecipeFactory);
        return brewingRecipeMaker.getBrewingRecipes();
    }

    private BrewingRecipeMaker(IIngredientManager ingredientManager, IVanillaRecipeFactory vanillaRecipeFactory) {
        this.ingredientManager = ingredientManager;
        this.vanillaRecipeFactory = vanillaRecipeFactory;
    }

    private List<IJeiBrewingRecipe> getBrewingRecipes() {
        this.unhandledRecipeClasses.clear();
        HashSet<IJeiBrewingRecipe> recipes = new HashSet<IJeiBrewingRecipe>();
        this.addVanillaBrewingRecipes(recipes);
        this.addModdedBrewingRecipes(recipes);
        ArrayList<IJeiBrewingRecipe> recipeList = new ArrayList<IJeiBrewingRecipe>(recipes);
        recipeList.sort(Comparator.comparingInt(IJeiBrewingRecipe::getBrewingSteps));
        return recipeList;
    }

    private void addVanillaBrewingRecipes(Collection<IJeiBrewingRecipe> recipes) {
        boolean foundNewPotions;
        List<ItemStack> potionIngredients = this.ingredientManager.getPotionIngredients();
        ArrayList<ItemStack> knownPotions = new ArrayList<ItemStack>();
        knownPotions.add(BrewingRecipeUtil.WATER_BOTTLE);
        do {
            List<ItemStack> newPotions;
            foundNewPotions = !(newPotions = this.getNewPotions(knownPotions, potionIngredients, recipes)).isEmpty();
            knownPotions.addAll(newPotions);
        } while (foundNewPotions);
    }

    private List<ItemStack> getNewPotions(List<ItemStack> knownPotions, List<ItemStack> potionIngredients, Collection<IJeiBrewingRecipe> recipes) {
        ArrayList<ItemStack> newPotions = new ArrayList<ItemStack>();
        for (ItemStack potionInput : knownPotions) {
            for (ItemStack potionIngredient : potionIngredients) {
                IJeiBrewingRecipe recipe;
                ResourceLocation outputId;
                PotionType potionInputType;
                ResourceLocation inputId;
                PotionType potionOutputType;
                ItemStack potionOutput = PotionBrewing.func_185212_d((ItemStack)potionIngredient, (ItemStack)potionInput.func_77946_l());
                if (potionOutput.equals(potionInput) || potionInput.func_77973_b() == potionOutput.func_77973_b() && ((potionOutputType = PotionUtils.func_185191_c((ItemStack)potionOutput)) == PotionTypes.field_185230_b || Objects.equals(inputId = ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)(potionInputType = PotionUtils.func_185191_c((ItemStack)potionInput))), outputId = ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)potionOutputType))) || recipes.contains(recipe = this.vanillaRecipeFactory.createBrewingRecipe(Collections.singletonList(potionIngredient), potionInput.func_77946_l(), potionOutput)) || this.disabledRecipes.contains(recipe)) continue;
                if (BrewingRecipeRegistry.hasOutput((ItemStack)potionInput, (ItemStack)potionIngredient)) {
                    recipes.add(recipe);
                } else {
                    this.disabledRecipes.add(recipe);
                }
                newPotions.add(potionOutput);
            }
        }
        return newPotions;
    }

    private void addModdedBrewingRecipes(Collection<IJeiBrewingRecipe> recipes) {
        List brewingRecipes = BrewingRecipeRegistry.getRecipes();
        this.addModdedBrewingRecipes(brewingRecipes, recipes);
    }

    private void addModdedBrewingRecipes(Collection<IBrewingRecipe> brewingRecipes, Collection<IJeiBrewingRecipe> recipes) {
    }
}

