/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.ingredients;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.plugins.jei.ingredients.DebugIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.TextFormatting;

public class DebugIngredientRenderer
implements IIngredientRenderer<DebugIngredient> {
    private final IIngredientHelper<DebugIngredient> ingredientHelper;

    public DebugIngredientRenderer(IIngredientHelper<DebugIngredient> ingredientHelper) {
        this.ingredientHelper = ingredientHelper;
    }

    @Override
    public void render(int xPosition, int yPosition, @Nullable DebugIngredient ingredient) {
        if (ingredient != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer font = this.getFontRenderer(minecraft, ingredient);
            font.func_211126_b("JEI", (float)xPosition, (float)yPosition, -65536);
            font.func_211126_b("#" + ingredient.getNumber(), (float)xPosition, (float)(yPosition + 8), -65536);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public List<String> getTooltip(DebugIngredient ingredient, ITooltipFlag tooltipFlag) {
        ArrayList<String> tooltip = new ArrayList<String>();
        String displayName = this.ingredientHelper.getDisplayName(ingredient);
        tooltip.add(displayName);
        tooltip.add(TextFormatting.GRAY + "debug ingredient");
        return tooltip;
    }
}

