/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.gui.textures.Textures;
import mezz.jei.plugins.debug.DebugRecipe;
import mezz.jei.plugins.debug.JeiDebugPlugin;
import mezz.jei.plugins.jei.ingredients.DebugIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class DebugRecipeCategory
implements IRecipeCategory<DebugRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("jei", "debug");
    public static final int RECIPE_WIDTH = 160;
    public static final int RECIPE_HEIGHT = 60;
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable tankBackground;
    private final IDrawable tankOverlay;
    private boolean hiddenRecipes;

    public DebugRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, 60);
        this.localizedName = "debug";
        ResourceLocation backgroundTexture = new ResourceLocation("jei", "textures/gui/debug.png");
        this.tankBackground = guiHelper.drawableBuilder(backgroundTexture, 220, 196, 18, 60).addPadding(-1, -1, -1, -1).build();
        this.tankOverlay = guiHelper.drawableBuilder(backgroundTexture, 238, 196, 18, 60).addPadding(-1, -1, -1, -1).build();
    }

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public Class<? extends DebugRecipe> getRecipeClass() {
        return DebugRecipe.class;
    }

    @Override
    public String getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        Textures textures = Internal.getTextures();
        return textures.getConfigButtonIcon();
    }

    @Override
    public void setIngredients(DebugRecipe recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, new ItemStack((IItemProvider)Items.field_151055_y));
        ingredients.setInputLists(DebugIngredient.TYPE, Collections.singletonList(Arrays.asList(new DebugIngredient(0), new DebugIngredient(1))));
        ingredients.setOutputs(DebugIngredient.TYPE, Arrays.asList(new DebugIngredient(2), new DebugIngredient(3)));
    }

    @Override
    public void draw(DebugRecipe recipe, double mouseX, double mouseY) {
        IJeiRuntime runtime = JeiDebugPlugin.jeiRuntime;
        if (runtime != null) {
            IIngredientFilter ingredientFilter = runtime.getIngredientFilter();
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.field_71466_p.func_211126_b(ingredientFilter.getFilterText(), 20.0f, 52.0f, 0);
            IIngredientListOverlay ingredientListOverlay = runtime.getIngredientListOverlay();
            Object ingredientUnderMouse = ingredientListOverlay.getIngredientUnderMouse();
            if (ingredientUnderMouse != null) {
                this.drawIngredientName(minecraft, ingredientUnderMouse);
            }
        }
        GuiButtonExt button = recipe.getButton();
        button.func_194828_a((int)mouseX, (int)mouseY, 0.0f);
    }

    private <T> void drawIngredientName(Minecraft minecraft, T ingredient) {
        IIngredientManager ingredientManager = JeiDebugPlugin.ingredientManager;
        if (ingredientManager != null) {
            IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredient);
            String jeiUid = ingredientHelper.getUniqueId(ingredient);
            minecraft.field_71466_p.func_211126_b(jeiUid, 50.0f, 52.0f, 0);
        }
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, DebugRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                tooltip.add(slotIndex + " Input itemStack");
            } else {
                tooltip.add(slotIndex + " Output itemStack");
            }
        });
        guiItemStacks.init(0, false, 70, 0);
        guiItemStacks.init(1, true, 110, 0);
        guiItemStacks.set(0, new ItemStack((IItemProvider)Items.field_151131_as));
        guiItemStacks.set(1, new ItemStack((IItemProvider)Items.field_151129_at));
        IGuiIngredientGroup<DebugIngredient> debugIngredientsGroup = recipeLayout.getIngredientsGroup(DebugIngredient.TYPE);
        debugIngredientsGroup.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                tooltip.add(slotIndex + " Input DebugIngredient");
            } else {
                tooltip.add(slotIndex + " Output DebugIngredient");
            }
        });
        debugIngredientsGroup.init(0, true, 40, 0);
        debugIngredientsGroup.init(1, false, 40, 16);
        debugIngredientsGroup.init(2, false, 40, 32);
        debugIngredientsGroup.set(ingredients);
    }

    @Override
    public List<String> getTooltipStrings(DebugRecipe recipe, double mouseX, double mouseY) {
        ArrayList<String> tooltipStrings = new ArrayList<String>();
        tooltipStrings.add("Debug Recipe Category Tooltip");
        if (recipe.checkHover(mouseX, mouseY)) {
            tooltipStrings.add("button tooltip!");
        } else {
            tooltipStrings.add(TextFormatting.BOLD + "tooltip debug");
        }
        tooltipStrings.add(mouseX + ", " + mouseY);
        return tooltipStrings;
    }

    @Override
    public boolean handleClick(DebugRecipe recipe, double mouseX, double mouseY, int mouseButton) {
        GuiButtonExt button = recipe.getButton();
        if (mouseButton == 0 && button.mouseClicked(mouseX, mouseY, mouseButton)) {
            IJeiRuntime runtime;
            Minecraft minecraft = Minecraft.func_71410_x();
            EntityPlayerSP player = minecraft.field_71439_g;
            if (player != null) {
                GuiInventory screen = new GuiInventory((EntityPlayer)player);
                minecraft.func_147108_a((GuiScreen)screen);
            }
            if ((runtime = JeiDebugPlugin.jeiRuntime) != null) {
                IIngredientFilter ingredientFilter = runtime.getIngredientFilter();
                String filterText = ingredientFilter.getFilterText();
                ingredientFilter.setFilterText(filterText + " test");
                IRecipeManager recipeManager = runtime.getRecipeManager();
                if (!this.hiddenRecipes) {
                    recipeManager.hideRecipeCategory(VanillaRecipeCategoryUid.CRAFTING);
                    this.hiddenRecipes = true;
                } else {
                    recipeManager.unhideRecipeCategory(VanillaRecipeCategoryUid.CRAFTING);
                    this.hiddenRecipes = false;
                }
            }
            return true;
        }
        return false;
    }
}

