/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.load.registration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.util.ErrorUtil;
import net.minecraft.util.ResourceLocation;

public class RecipeCategoryRegistration
implements IRecipeCategoryRegistration {
    private final List<IRecipeCategory> recipeCategories = new ArrayList<IRecipeCategory>();
    private final Map<ResourceLocation, IRecipeCategory> recipeCategoriesByUid = new HashMap<ResourceLocation, IRecipeCategory>();
    private final Set<Class<?>> recipeClasses = new HashSet();
    private final IJeiHelpers jeiHelpers;

    public RecipeCategoryRegistration(IJeiHelpers jeiHelpers) {
        this.jeiHelpers = jeiHelpers;
    }

    @Override
    public void addRecipeCategories(IRecipeCategory ... recipeCategories) {
        ErrorUtil.checkNotEmpty(recipeCategories, "recipeCategories");
        for (IRecipeCategory recipeCategory : recipeCategories) {
            ResourceLocation uid = recipeCategory.getUid();
            Preconditions.checkNotNull((Object)uid, (String)"Recipe category UID cannot be null %s", (Object)recipeCategory);
            Class recipeClass = recipeCategory.getRecipeClass();
            Preconditions.checkNotNull(recipeClass, (String)"Recipe class cannot be null %s", (Object)recipeCategory);
            if (!this.recipeClasses.add(recipeClass)) {
                throw new IllegalArgumentException("A RecipeCategory for recipe class \"" + recipeClass + "\" has already been registered.");
            }
            if (this.recipeCategoriesByUid.containsKey(uid)) {
                throw new IllegalArgumentException("A RecipeCategory with UID \"" + uid + "\" has already been registered.");
            }
            this.recipeCategoriesByUid.put(uid, recipeCategory);
        }
        Collections.addAll(this.recipeCategories, recipeCategories);
    }

    @Override
    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    public ImmutableList<IRecipeCategory> getRecipeCategories() {
        return ImmutableList.copyOf(this.recipeCategories);
    }

    public ImmutableMap<ResourceLocation, IRecipeCategory> getRecipeCategoriesByUid() {
        return ImmutableMap.copyOf(this.recipeCategoriesByUid);
    }
}

