/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.IHideModeConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.IngredientBlacklistType;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.LeftAreaDispatcher;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.GuiContainerWrapper;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.MouseUtil;
import mezz.jei.util.ReflectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class InputHandler {
    private final IIngredientManager ingredientManager;
    private final IngredientFilter ingredientFilter;
    private final RecipesGui recipesGui;
    private final IngredientListOverlay ingredientListOverlay;
    private final IHideModeConfig hideModeConfig;
    private final IWorldConfig worldConfig;
    private final GuiScreenHelper guiScreenHelper;
    private final LeftAreaDispatcher leftAreaDispatcher;
    private final BookmarkList bookmarkList;
    private final List<IShowsRecipeFocuses> showsRecipeFocuses = new ArrayList<IShowsRecipeFocuses>();
    private final IntSet clickHandled = new IntArraySet();

    public InputHandler(RecipesGui recipesGui, IngredientFilter ingredientFilter, IngredientManager ingredientManager, IngredientListOverlay ingredientListOverlay, IHideModeConfig hideModeConfig, IWorldConfig worldConfig, GuiScreenHelper guiScreenHelper, LeftAreaDispatcher leftAreaDispatcher, BookmarkList bookmarkList) {
        this.ingredientManager = ingredientManager;
        this.ingredientFilter = ingredientFilter;
        this.recipesGui = recipesGui;
        this.ingredientListOverlay = ingredientListOverlay;
        this.hideModeConfig = hideModeConfig;
        this.worldConfig = worldConfig;
        this.guiScreenHelper = guiScreenHelper;
        this.leftAreaDispatcher = leftAreaDispatcher;
        this.bookmarkList = bookmarkList;
        this.showsRecipeFocuses.add(recipesGui);
        this.showsRecipeFocuses.add(ingredientListOverlay);
        this.showsRecipeFocuses.add(leftAreaDispatcher);
        this.showsRecipeFocuses.add(new GuiContainerWrapper(guiScreenHelper));
    }

    @SubscribeEvent
    public void onGuiKeyPressedEvent(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        if (this.hasKeyboardFocus() && this.handleKeyEvent(event.getKeyCode(), event.getScanCode(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiCharTypedEvent(GuiScreenEvent.KeyboardCharTypedEvent.Pre event) {
        if (this.hasKeyboardFocus() && this.handleCharTyped(event.getCodePoint(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiKeyboardEvent(GuiScreenEvent.KeyboardKeyPressedEvent.Post event) {
        if (!this.hasKeyboardFocus() && this.handleKeyEvent(event.getKeyCode(), event.getScanCode(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiCharTypedEvent(GuiScreenEvent.KeyboardCharTypedEvent.Post event) {
        if (!this.hasKeyboardFocus() && this.handleCharTyped(event.getCodePoint(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiMouseEvent(GuiScreenEvent.MouseClickedEvent.Pre event) {
        int mouseButton = event.getButton();
        if (mouseButton > -1 && !this.clickHandled.contains(mouseButton) && this.handleMouseClick(event.getGui(), mouseButton, event.getMouseX(), event.getMouseY())) {
            this.clickHandled.add(mouseButton);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiMouseEvent(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        int mouseButton = event.getButton();
        if (mouseButton > -1 && this.clickHandled.contains(mouseButton)) {
            this.clickHandled.remove(mouseButton);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiMouseEvent(GuiScreenEvent.MouseScrollEvent.Pre event) {
        double mouseY;
        double dWheel = event.getScrollDelta();
        double mouseX = event.getMouseX();
        if (this.ingredientListOverlay.handleMouseScrolled(mouseX, mouseY = event.getMouseY(), dWheel) || this.leftAreaDispatcher.handleMouseScrolled(mouseX, mouseY, dWheel)) {
            event.setCanceled(true);
        }
    }

    private boolean handleMouseClick(GuiScreen guiScreen, int mouseButton, double mouseX, double mouseY) {
        GuiContainer guiContainer;
        IGuiClickableArea clickableArea;
        IClickedIngredient<?> clicked = this.getFocusUnderMouseForClick(mouseX, mouseY);
        if (this.worldConfig.isHideModeEnabled() && clicked != null && this.handleClickEdit(clicked)) {
            return true;
        }
        if (this.ingredientListOverlay.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.leftAreaDispatcher.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (clicked != null && this.handleMouseClickedFocus(mouseButton, clicked)) {
            return true;
        }
        InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(mouseButton);
        if (this.handleFocusKeybinds(input)) {
            return true;
        }
        if (guiScreen instanceof GuiContainer && (clickableArea = this.guiScreenHelper.getGuiClickableArea(guiContainer = (GuiContainer)guiScreen, mouseX - (double)guiContainer.getGuiLeft(), mouseY - (double)guiContainer.getGuiTop())) != null) {
            clickableArea.onClick(Focus::new, this.recipesGui);
            return true;
        }
        return this.handleGlobalKeybinds(input);
    }

    @Nullable
    private IClickedIngredient<?> getFocusUnderMouseForClick(double mouseX, double mouseY) {
        for (IShowsRecipeFocuses gui : this.showsRecipeFocuses) {
            IClickedIngredient<?> clicked;
            if (!gui.canSetFocusWithMouse() || (clicked = gui.getIngredientUnderMouse(mouseX, mouseY)) == null) continue;
            return clicked;
        }
        return null;
    }

    @Nullable
    private IClickedIngredient<?> getIngredientUnderMouseForKey(double mouseX, double mouseY) {
        for (IShowsRecipeFocuses gui : this.showsRecipeFocuses) {
            IClickedIngredient<?> clicked = gui.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked == null) continue;
            return clicked;
        }
        return null;
    }

    private <V> boolean handleMouseClickedFocus(int mouseButton, IClickedIngredient<V> clicked) {
        if (mouseButton == 0) {
            Focus<V> focus = new Focus<V>(IFocus.Mode.OUTPUT, clicked.getValue());
            this.recipesGui.show(focus);
            clicked.onClickHandled();
            return true;
        }
        if (mouseButton == 1) {
            Focus<V> focus = new Focus<V>(IFocus.Mode.INPUT, clicked.getValue());
            this.recipesGui.show(focus);
            clicked.onClickHandled();
            return true;
        }
        return false;
    }

    private <V> boolean handleClickEdit(IClickedIngredient<V> clicked) {
        V ingredient = clicked.getValue();
        IngredientBlacklistType blacklistType = GuiScreen.func_146271_m() ? IngredientBlacklistType.WILDCARD : IngredientBlacklistType.ITEM;
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient);
        if (this.hideModeConfig.isIngredientOnConfigBlacklist(ingredient, ingredientHelper)) {
            this.hideModeConfig.removeIngredientFromConfigBlacklist(this.ingredientFilter, this.ingredientManager, ingredient, blacklistType, ingredientHelper);
        } else {
            this.hideModeConfig.addIngredientToConfigBlacklist(this.ingredientFilter, this.ingredientManager, ingredient, blacklistType, ingredientHelper);
        }
        clicked.onClickHandled();
        return true;
    }

    private boolean hasKeyboardFocus() {
        return true;
    }

    private boolean handleCharTyped(char codePoint, int modifiers) {
        return this.ingredientListOverlay.onCharTyped(codePoint, modifiers);
    }

    private boolean handleKeyEvent(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input input = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (this.ingredientListOverlay.hasKeyboardFocus()) {
            if (KeyBindings.isInventoryCloseKey(input) || KeyBindings.isEnterKey(keyCode)) {
                this.ingredientListOverlay.setKeyboardFocus(false);
                return true;
            }
            if (this.ingredientListOverlay.onKeyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        if (this.handleGlobalKeybinds(input)) {
            return true;
        }
        if (!this.isContainerTextFieldFocused()) {
            if (this.handleFocusKeybinds(input)) {
                return true;
            }
            return this.ingredientListOverlay.onKeyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    private boolean handleGlobalKeybinds(InputMappings.Input input) {
        if (KeyBindings.toggleOverlay.isActiveAndMatches(input)) {
            this.worldConfig.toggleOverlayEnabled();
            return false;
        }
        if (KeyBindings.toggleBookmarkOverlay.isActiveAndMatches(input)) {
            this.worldConfig.toggleBookmarkEnabled();
            return false;
        }
        return this.ingredientListOverlay.onGlobalKeyPressed(input);
    }

    private boolean handleFocusKeybinds(InputMappings.Input input) {
        IClickedIngredient<?> clicked;
        boolean showRecipe = KeyBindings.showRecipe.isActiveAndMatches(input);
        boolean showUses = KeyBindings.showUses.isActiveAndMatches(input);
        boolean bookmark = KeyBindings.bookmark.isActiveAndMatches(input);
        if ((showRecipe || showUses || bookmark) && (clicked = this.getIngredientUnderMouseForKey(MouseUtil.getX(), MouseUtil.getY())) != null) {
            if (bookmark) {
                if (this.bookmarkList.remove(clicked.getValue())) {
                    if (this.bookmarkList.isEmpty()) {
                        this.worldConfig.setBookmarkEnabled(false);
                    }
                    return true;
                }
                this.worldConfig.setBookmarkEnabled(true);
                return this.bookmarkList.add(clicked.getValue());
            }
            IFocus.Mode mode = showRecipe ? IFocus.Mode.OUTPUT : IFocus.Mode.INPUT;
            this.recipesGui.show(new Focus(mode, clicked.getValue()));
            clicked.onClickHandled();
            return true;
        }
        return false;
    }

    private boolean isContainerTextFieldFocused() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null) {
            return false;
        }
        GuiTextField textField = ReflectionUtil.getFieldWithClass(gui, GuiTextField.class);
        return textField != null && textField.func_146176_q() && textField.func_146206_l();
    }
}

