/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.config.IHideModeConfig;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.SearchMode;
import mezz.jei.events.EditModeToggleEvent;
import mezz.jei.events.EventBusHelper;
import mezz.jei.events.PlayerJoinedWorldEvent;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.ingredients.IIngredientListElementInfo;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientFilterBackgroundBuilder;
import mezz.jei.ingredients.IngredientListElementComparator;
import mezz.jei.ingredients.IngredientListElementInfo;
import mezz.jei.ingredients.PrefixedSearchTree;
import mezz.jei.suffixtree.CombinedSearchTrees;
import mezz.jei.suffixtree.GeneralizedSuffixTree;
import mezz.jei.suffixtree.ISearchTree;
import mezz.jei.util.Translator;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.progress.ProgressBar;
import net.minecraftforge.fml.common.progress.StartupProgressManager;

public class IngredientFilter
implements IIngredientGridSource {
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern FILTER_SPLIT_PATTERN = Pattern.compile("(-?\".*?(?:\"|$)|\\S+)");
    private final IngredientBlacklistInternal blacklist;
    private final IHideModeConfig hideModeConfig;
    private final IIngredientManager ingredientManager;
    private final NonNullList<IIngredientListElement> elementList;
    private final GeneralizedSuffixTree searchTree;
    private final Char2ObjectMap<PrefixedSearchTree> prefixedSearchTrees = new Char2ObjectOpenHashMap();
    private final IngredientFilterBackgroundBuilder backgroundBuilder;
    private CombinedSearchTrees combinedSearchTrees;
    @Nullable
    private String filterCached;
    private List<IIngredientListElement<?>> ingredientListCached = Collections.emptyList();
    private final List<IIngredientGridSource.Listener> listeners = new ArrayList<IIngredientGridSource.Listener>();

    public IngredientFilter(IngredientBlacklistInternal blacklist, IIngredientFilterConfig config, IHideModeConfig hideModeConfig, IIngredientManager ingredientManager, IModIdHelper modIdHelper) {
        this.blacklist = blacklist;
        this.hideModeConfig = hideModeConfig;
        this.ingredientManager = ingredientManager;
        this.elementList = NonNullList.func_191196_a();
        this.searchTree = new GeneralizedSuffixTree();
        this.createPrefixedSearchTree('@', config::getModNameSearchMode, IIngredientListElementInfo::getModNameStrings);
        this.createPrefixedSearchTree('#', config::getTooltipSearchMode, e -> e.getTooltipStrings(config));
        this.createPrefixedSearchTree('$', config::getTagSearchMode, IIngredientListElementInfo::getTagStrings);
        this.createPrefixedSearchTree('%', config::getCreativeTabSearchMode, IIngredientListElementInfo::getCreativeTabsStrings);
        this.createPrefixedSearchTree('^', config::getColorSearchMode, IIngredientListElementInfo::getColorStrings);
        this.createPrefixedSearchTree('&', config::getResourceIdSearchMode, element -> Collections.singleton(element.getResourceId()));
        this.combinedSearchTrees = IngredientFilter.buildCombinedSearchTrees(this.searchTree, (Collection<PrefixedSearchTree>)this.prefixedSearchTrees.values());
        this.backgroundBuilder = new IngredientFilterBackgroundBuilder(this.prefixedSearchTrees, this.elementList, ingredientManager, modIdHelper);
        EventBusHelper.addListener(EditModeToggleEvent.class, editModeToggleEvent -> {
            this.filterCached = null;
            this.updateHidden();
        });
        EventBusHelper.addListener(PlayerJoinedWorldEvent.class, playerJoinedWorldEvent -> {
            this.filterCached = null;
            this.updateHidden();
        });
    }

    private static CombinedSearchTrees buildCombinedSearchTrees(ISearchTree searchTree, Collection<PrefixedSearchTree> prefixedSearchTrees) {
        CombinedSearchTrees combinedSearchTrees = new CombinedSearchTrees();
        combinedSearchTrees.addSearchTree(searchTree);
        for (PrefixedSearchTree prefixedTree : prefixedSearchTrees) {
            if (prefixedTree.getMode() != SearchMode.ENABLED) continue;
            combinedSearchTrees.addSearchTree(prefixedTree.getTree());
        }
        return combinedSearchTrees;
    }

    private void createPrefixedSearchTree(char prefix, PrefixedSearchTree.IModeGetter modeGetter, PrefixedSearchTree.IStringsGetter stringsGetter) {
        GeneralizedSuffixTree tree = new GeneralizedSuffixTree();
        PrefixedSearchTree prefixedTree = new PrefixedSearchTree(tree, stringsGetter, modeGetter);
        this.prefixedSearchTrees.put(prefix, (Object)prefixedTree);
    }

    public void addIngredients(NonNullList<IIngredientListElement<?>> ingredients, IIngredientManager ingredientManager, IModIdHelper modIdHelper) {
        List ingredientInfo = ingredients.stream().map(i -> IngredientListElementInfo.create(i, ingredientManager, modIdHelper)).sorted(IngredientListElementComparator.INSTANCE).collect(Collectors.toList());
        long modNameCount = ingredientInfo.stream().map(IIngredientListElementInfo::getModNameForSorting).distinct().count();
        try (ProgressBar progressBar = StartupProgressManager.start((String)"Indexing ingredients", (int)((int)modNameCount));){
            String currentModName = null;
            for (IIngredientListElementInfo element : ingredientInfo) {
                String modname = element.getModNameForSorting();
                if (!Objects.equals(currentModName, modname)) {
                    currentModName = modname;
                    progressBar.step(modname);
                }
                this.addIngredient(element);
            }
        }
    }

    public <V> void addIngredient(IIngredientListElementInfo<V> info) {
        IIngredientListElement<V> element = info.getElement();
        this.updateHiddenState(element);
        int index = this.elementList.size();
        this.elementList.add(element);
        this.searchTree.put(Translator.toLowercaseWithLocale(info.getDisplayName()), index);
        for (PrefixedSearchTree prefixedSearchTree : this.prefixedSearchTrees.values()) {
            SearchMode searchMode = prefixedSearchTree.getMode();
            if (searchMode == SearchMode.DISABLED) continue;
            Collection<String> strings = prefixedSearchTree.getStringsGetter().getStrings(info);
            for (String string : strings) {
                prefixedSearchTree.getTree().put(string, index);
            }
        }
        this.filterCached = null;
    }

    public void invalidateCache() {
        this.filterCached = null;
    }

    public <V> List<IIngredientListElement<V>> findMatchingElements(IIngredientHelper<V> ingredientHelper, V ingredient) {
        String ingredientUid = ingredientHelper.getUniqueId(ingredient);
        String displayName = ingredientHelper.getDisplayName(ingredient);
        Class<?> ingredientClass = ingredient.getClass();
        ArrayList<IIngredientListElement<V>> matchingElements = new ArrayList<IIngredientListElement<V>>();
        IntSet matchingIndexes = this.searchTree.search(Translator.toLowercaseWithLocale(displayName));
        IntIterator iterator = matchingIndexes.iterator();
        while (iterator.hasNext()) {
            Object castMatchingIngredient;
            String matchingUid;
            int index = iterator.nextInt();
            IIngredientListElement matchingElement = (IIngredientListElement)this.elementList.get(index);
            Object matchingIngredient = matchingElement.getIngredient();
            if (!ingredientClass.isInstance(matchingIngredient) || !ingredientUid.equals(matchingUid = ingredientHelper.getUniqueId(castMatchingIngredient = ingredientClass.cast(matchingIngredient)))) continue;
            IIngredientListElement matchingElementCast = matchingElement;
            matchingElements.add(matchingElementCast);
        }
        return matchingElements;
    }

    public void modesChanged() {
        this.combinedSearchTrees = IngredientFilter.buildCombinedSearchTrees(this.searchTree, (Collection<PrefixedSearchTree>)this.prefixedSearchTrees.values());
        this.backgroundBuilder.start();
        this.filterCached = null;
    }

    public void updateHidden() {
        for (IIngredientListElement element : this.elementList) {
            this.updateHiddenState(element);
        }
    }

    public <V> void updateHiddenState(IIngredientListElement<V> element) {
        IIngredientHelper<V> ingredientHelper;
        boolean visible;
        V ingredient = element.getIngredient();
        boolean bl = visible = !this.blacklist.isIngredientBlacklistedByApi(ingredient, ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient)) && ingredientHelper.isIngredientOnServer(ingredient) && (this.hideModeConfig.isHideModeEnabled() || !this.hideModeConfig.isIngredientOnConfigBlacklist(ingredient, ingredientHelper));
        if (element.isVisible() != visible) {
            element.setVisible(visible);
            this.filterCached = null;
        }
    }

    @Override
    public List<IIngredientListElement<?>> getIngredientList(String filterText) {
        if (!filterText.equals(this.filterCached)) {
            List<IIngredientListElement<?>> ingredientList = this.getIngredientListUncached(filterText);
            this.ingredientListCached = Collections.unmodifiableList(ingredientList);
            this.filterCached = filterText;
        }
        return this.ingredientListCached;
    }

    public ImmutableList<Object> getFilteredIngredients(String filterText) {
        List<IIngredientListElement<?>> elements = this.getIngredientList(filterText);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IIngredientListElement<?> element : elements) {
            Object ingredient = element.getIngredient();
            builder.add(ingredient);
        }
        return builder.build();
    }

    private List<IIngredientListElement<?>> getIngredientListUncached(String filterText) {
        String[] filters = filterText.split("\\|");
        IntSet matches = null;
        for (String filter : filters) {
            IntSet elements = this.getElements(filter);
            if (elements == null) continue;
            if (matches == null) {
                matches = elements;
                continue;
            }
            matches.addAll((IntCollection)elements);
        }
        ArrayList matchingIngredients = new ArrayList();
        if (matches == null) {
            for (IIngredientListElement element : this.elementList) {
                if (!element.isVisible()) continue;
                matchingIngredients.add(element);
            }
        } else {
            int[] matchesList = matches.toIntArray();
            Arrays.sort(matchesList);
            for (int match : matchesList) {
                IIngredientListElement element = (IIngredientListElement)this.elementList.get(match);
                if (!element.isVisible()) continue;
                matchingIngredients.add(element);
            }
        }
        return matchingIngredients;
    }

    public <T> List<IIngredientListElement<T>> getMatches(T ingredient, IIngredientHelper<T> ingredientHelper, Function<T, String> uidFunction) {
        String uid = uidFunction.apply(ingredient);
        Class<?> ingredientClass = ingredient.getClass();
        List<IIngredientListElement<T>> matchingElements = this.findMatchingElements(ingredientHelper, ingredient);
        IntOpenHashSet matchingIndexes = new IntOpenHashSet(50);
        IntOpenHashSet startingIndexes = new IntOpenHashSet(matchingElements.size());
        for (IIngredientListElement<T> matchingElement : matchingElements) {
            int index = this.elementList.indexOf(matchingElement);
            startingIndexes.add(index);
            matchingIndexes.add(index);
        }
        IntIterator iterator = startingIndexes.iterator();
        while (iterator.hasNext()) {
            IIngredientListElement castElement;
            String elementWildcardId;
            IIngredientListElement element;
            Object elementIngredient;
            int i;
            int startingIndex = iterator.nextInt();
            for (i = startingIndex - 1; i >= 0 && !matchingIndexes.contains(i) && (elementIngredient = (element = (IIngredientListElement)this.elementList.get(i)).getIngredient()).getClass() == ingredientClass && uid.equals(elementWildcardId = uidFunction.apply(ingredientClass.cast(elementIngredient))); --i) {
                matchingIndexes.add(i);
                castElement = element;
                matchingElements.add(castElement);
            }
            for (i = startingIndex + 1; i < this.elementList.size() && !matchingIndexes.contains(i) && (elementIngredient = (element = (IIngredientListElement)this.elementList.get(i)).getIngredient()).getClass() == ingredientClass && uid.equals(elementWildcardId = uidFunction.apply(ingredientClass.cast(elementIngredient))); ++i) {
                matchingIndexes.add(i);
                castElement = element;
                matchingElements.add(castElement);
            }
        }
        return matchingElements;
    }

    @Nullable
    private IntSet getElements(String filterText) {
        Matcher filterMatcher = FILTER_SPLIT_PATTERN.matcher(filterText);
        IntSet matches = null;
        IntSet removeMatches = null;
        while (filterMatcher.find()) {
            IntSet searchResults;
            String token = filterMatcher.group(1);
            boolean remove = token.startsWith("-");
            if (remove) {
                token = token.substring(1);
            }
            if ((searchResults = this.getSearchResults(token = QUOTE_PATTERN.matcher(token).replaceAll(""))) == null) continue;
            if (remove) {
                if (removeMatches == null) {
                    removeMatches = searchResults;
                    continue;
                }
                removeMatches.addAll((IntCollection)searchResults);
                continue;
            }
            if (!(matches = matches == null ? searchResults : IngredientFilter.intersection(matches, searchResults)).isEmpty()) continue;
            break;
        }
        if (matches != null && removeMatches != null) {
            matches.removeAll(removeMatches);
        }
        return matches;
    }

    @Nullable
    private IntSet getSearchResults(String token) {
        if (token.isEmpty()) {
            return null;
        }
        char firstChar = token.charAt(0);
        PrefixedSearchTree prefixedSearchTree = (PrefixedSearchTree)this.prefixedSearchTrees.get(firstChar);
        if (prefixedSearchTree != null && prefixedSearchTree.getMode() != SearchMode.DISABLED) {
            if ((token = token.substring(1)).isEmpty()) {
                return null;
            }
            GeneralizedSuffixTree tree = prefixedSearchTree.getTree();
            return tree.search(token);
        }
        return this.combinedSearchTrees.search(token);
    }

    private static IntSet intersection(IntSet set1, IntSet set2) {
        if (set1.size() > set2.size()) {
            set2.retainAll((IntCollection)set1);
            return set2;
        }
        set1.retainAll((IntCollection)set2);
        return set1;
    }

    @Override
    public void addListener(IIngredientGridSource.Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListenersOfChange() {
        for (IIngredientGridSource.Listener listener : this.listeners) {
            listener.onChange();
        }
    }
}

