/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import mezz.jei.Internal;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.gui.textures.Textures;
import mezz.jei.input.IPaged;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Rectangle2d;

public class PageNavigation {
    private final IPaged paged;
    private final GuiButton nextButton;
    private final GuiButton backButton;
    private final boolean hideOnSinglePage;
    private String pageNumDisplayString = "1/1";
    private int pageNumDisplayX;
    private int pageNumDisplayY;

    public PageNavigation(final IPaged paged, boolean hideOnSinglePage) {
        this.paged = paged;
        Textures textures = Internal.getTextures();
        this.nextButton = new GuiIconButton(0, textures.getArrowNext()){

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                boolean result = super.mouseClicked(mouseX, mouseY, mouseButton);
                if (result) {
                    paged.nextPage();
                }
                return result;
            }
        };
        this.backButton = new GuiIconButton(1, textures.getArrowPrevious()){

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                boolean result = super.mouseClicked(mouseX, mouseY, mouseButton);
                if (result) {
                    paged.previousPage();
                }
                return result;
            }
        };
        this.hideOnSinglePage = hideOnSinglePage;
    }

    public void updateBounds(Rectangle2d area) {
        int buttonSize = area.func_199317_d();
        this.nextButton.field_146128_h = area.func_199318_a() + area.func_199316_c() - buttonSize;
        this.nextButton.field_146129_i = area.func_199319_b();
        this.nextButton.field_146120_f = this.nextButton.field_146121_g = buttonSize;
        this.backButton.field_146128_h = area.func_199318_a();
        this.backButton.field_146129_i = area.func_199319_b();
        this.backButton.field_146120_f = this.backButton.field_146121_g = buttonSize;
    }

    public void updatePageState() {
        int pageNum = this.paged.getPageNumber();
        int pageCount = this.paged.getPageCount();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.pageNumDisplayString = pageNum + 1 + "/" + pageCount;
        int pageDisplayWidth = fontRenderer.func_78256_a(this.pageNumDisplayString);
        this.pageNumDisplayX = (this.backButton.field_146128_h + this.backButton.field_146120_f + this.nextButton.field_146128_h) / 2 - pageDisplayWidth / 2;
        this.pageNumDisplayY = this.backButton.field_146129_i + Math.round((float)(this.backButton.field_146121_g - fontRenderer.field_78288_b) / 2.0f);
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (!this.hideOnSinglePage || this.paged.hasNext() || this.paged.hasPrevious()) {
            minecraft.field_71466_p.func_175063_a(this.pageNumDisplayString, (float)this.pageNumDisplayX, (float)this.pageNumDisplayY, -1);
            this.nextButton.func_194828_a(mouseX, mouseY, partialTicks);
            this.backButton.func_194828_a(mouseX, mouseY, partialTicks);
        }
    }

    public boolean isMouseOver() {
        return this.nextButton.func_146115_a() || this.backButton.func_146115_a();
    }

    public boolean handleMouseClickedButtons(double mouseX, double mouseY, int mouseButton) {
        return this.nextButton.mouseClicked(mouseX, mouseY, mouseButton) || this.backButton.mouseClicked(mouseX, mouseY, mouseButton);
    }
}

