/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.handlers.IGuiScreenHandler;
import mezz.jei.collect.ListMultiMap;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class GuiScreenHelper {
    private final IngredientManager ingredientManager;
    private final List<IGlobalGuiHandler> globalGuiHandlers;
    private final ListMultiMap<Class<? extends GuiContainer>, IGuiContainerHandler<?>> guiHandlers;
    private final Map<Class, IGhostIngredientHandler> ghostIngredientHandlers;
    private final Map<Class, IGuiScreenHandler> guiScreenHandlers;
    private Set<Rectangle2d> guiExclusionAreas = Collections.emptySet();

    public GuiScreenHelper(IngredientManager ingredientManager, List<IGlobalGuiHandler> globalGuiHandlers, ListMultiMap<Class<? extends GuiContainer>, IGuiContainerHandler<?>> guiHandlers, Map<Class, IGhostIngredientHandler> ghostIngredientHandlers, Map<Class, IGuiScreenHandler> guiScreenHandlers) {
        this.ingredientManager = ingredientManager;
        this.globalGuiHandlers = globalGuiHandlers;
        this.guiHandlers = guiHandlers;
        this.ghostIngredientHandlers = ghostIngredientHandlers;
        this.guiScreenHandlers = guiScreenHandlers;
    }

    @Nullable
    public <T extends GuiScreen> IGuiProperties getGuiProperties(@Nullable T guiScreen) {
        if (guiScreen == null) {
            return null;
        }
        IGuiScreenHandler handler = this.guiScreenHandlers.get(guiScreen.getClass());
        if (handler != null) {
            return handler.apply(guiScreen);
        }
        for (Map.Entry<Class, IGuiScreenHandler> entry : this.guiScreenHandlers.entrySet()) {
            IGuiScreenHandler handler2;
            Class guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(guiScreen) || (handler2 = entry.getValue()) == null) continue;
            return handler2.apply(guiScreen);
        }
        return null;
    }

    public boolean updateGuiExclusionAreas() {
        Set<Rectangle2d> guiAreas = this.getPluginsExclusionAreas();
        if (!guiAreas.equals(this.guiExclusionAreas)) {
            this.guiExclusionAreas = guiAreas;
            return true;
        }
        return false;
    }

    public Set<Rectangle2d> getGuiExclusionAreas() {
        return this.guiExclusionAreas;
    }

    public boolean isInGuiExclusionArea(double mouseX, double mouseY) {
        return MathUtil.contains(this.guiExclusionAreas, mouseX, mouseY);
    }

    private Set<Rectangle2d> getPluginsExclusionAreas() {
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (guiScreen == null) {
            return Collections.emptySet();
        }
        HashSet<Rectangle2d> allGuiExtraAreas = new HashSet<Rectangle2d>();
        if (guiScreen instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)guiScreen;
            List<IGuiContainerHandler<GuiContainer>> activeAdvancedGuiHandlers = this.getActiveAdvancedGuiHandlers(guiContainer);
            for (IGuiContainerHandler<GuiContainer> advancedGuiHandler : activeAdvancedGuiHandlers) {
                List<Rectangle2d> guiExtraAreas = advancedGuiHandler.getGuiExtraAreas(guiContainer);
                allGuiExtraAreas.addAll(guiExtraAreas);
            }
        }
        for (IGlobalGuiHandler globalGuiHandler : this.globalGuiHandlers) {
            Collection<Rectangle2d> guiExtraAreas = globalGuiHandler.getGuiExtraAreas();
            allGuiExtraAreas.addAll(guiExtraAreas);
        }
        return allGuiExtraAreas;
    }

    @Nullable
    public <T extends GuiContainer> IClickedIngredient<?> getPluginsIngredientUnderMouse(T guiContainer, double mouseX, double mouseY) {
        IClickedIngredient<Object> clickedIngredient;
        Object clicked;
        List<IGuiContainerHandler<T>> activeAdvancedGuiHandlers = this.getActiveAdvancedGuiHandlers(guiContainer);
        for (IGuiContainerHandler<T> advancedGuiHandler : activeAdvancedGuiHandlers) {
            clicked = advancedGuiHandler.getIngredientUnderMouse(guiContainer, mouseX, mouseY);
            clickedIngredient = this.createClickedIngredient(clicked, guiContainer);
            if (clickedIngredient == null) continue;
            return clickedIngredient;
        }
        for (IGlobalGuiHandler globalGuiHandler : this.globalGuiHandlers) {
            clicked = globalGuiHandler.getIngredientUnderMouse(mouseX, mouseY);
            clickedIngredient = this.createClickedIngredient(clicked, guiContainer);
            if (clickedIngredient == null) continue;
            return clickedIngredient;
        }
        return null;
    }

    @Nullable
    public <T extends GuiScreen> IGhostIngredientHandler<T> getGhostIngredientHandler(T guiScreen) {
        IGhostIngredientHandler handler = this.ghostIngredientHandlers.get(guiScreen.getClass());
        if (handler != null) {
            return handler;
        }
        for (Map.Entry<Class, IGhostIngredientHandler> entry : this.ghostIngredientHandlers.entrySet()) {
            IGhostIngredientHandler handler2;
            Class guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(guiScreen) || (handler2 = entry.getValue()) == null) continue;
            return handler2;
        }
        return null;
    }

    @Nullable
    private <T> IClickedIngredient<T> createClickedIngredient(@Nullable T ingredient, GuiContainer guiContainer) {
        if (ingredient != null && this.ingredientManager.isValidIngredient(ingredient)) {
            Rectangle2d area = null;
            Slot slotUnderMouse = guiContainer.getSlotUnderMouse();
            if (ingredient instanceof ItemStack && slotUnderMouse != null && ItemStack.func_77989_b((ItemStack)slotUnderMouse.func_75211_c(), (ItemStack)((ItemStack)ingredient))) {
                area = new Rectangle2d(slotUnderMouse.field_75223_e, slotUnderMouse.field_75221_f, 16, 16);
            }
            return ClickedIngredient.create(ingredient, area);
        }
        return null;
    }

    private <T extends GuiContainer> List<IGuiContainerHandler<T>> getActiveAdvancedGuiHandlers(T guiContainer) {
        ArrayList<IGuiContainerHandler<T>> activeAdvancedGuiHandler = new ArrayList<IGuiContainerHandler<T>>();
        for (Map.Entry entry : this.guiHandlers.entrySet()) {
            Class guiContainerClass = (Class)entry.getKey();
            if (!guiContainerClass.isInstance(guiContainer)) continue;
            Iterator iterator = ((List)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                IGuiContainerHandler guiContainerHandler;
                IGuiContainerHandler guiContainerHandlerCast = guiContainerHandler = (IGuiContainerHandler)iterator.next();
                activeAdvancedGuiHandler.add(guiContainerHandlerCast);
            }
        }
        return activeAdvancedGuiHandler;
    }

    @Nullable
    public IGuiClickableArea getGuiClickableArea(GuiContainer guiContainer, double mouseX, double mouseY) {
        for (Map.Entry entry : this.guiHandlers.entrySet()) {
            Class guiHandlerClass = (Class)entry.getKey();
            List guiHandlers = (List)entry.getValue();
            for (IGuiContainerHandler guiHandler : guiHandlers) {
                IGuiClickableArea guiClickableArea = GuiScreenHelper.getGuiClickableArea(guiHandlerClass, guiHandler, guiContainer, mouseX, mouseY);
                if (guiClickableArea == null) continue;
                return guiClickableArea;
            }
        }
        return null;
    }

    @Nullable
    private static <T extends GuiContainer> IGuiClickableArea getGuiClickableArea(Class<? extends T> handlerClass, IGuiContainerHandler<T> handler, GuiContainer guiContainer, double mouseX, double mouseY) {
        if (handlerClass.isInstance(guiContainer)) {
            GuiContainer castContainer = (GuiContainer)handlerClass.cast(guiContainer);
            Collection<IGuiClickableArea> guiClickableAreas = handler.getGuiClickableAreas(castContainer);
            for (IGuiClickableArea guiClickableArea : guiClickableAreas) {
                if (!MathUtil.contains(guiClickableArea.getArea(), mouseX, mouseY)) continue;
                return guiClickableArea;
            }
        }
        return null;
    }
}

