/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import java.io.File;
import javax.annotation.Nullable;
import mezz.jei.config.IFilterTextSource;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.ServerInfo;
import mezz.jei.config.WorldConfigValues;
import mezz.jei.config.forge.Configuration;
import mezz.jei.config.forge.Property;
import mezz.jei.events.BookmarkOverlayToggleEvent;
import mezz.jei.events.EditModeToggleEvent;
import mezz.jei.events.EventBusHelper;
import mezz.jei.events.OverlayToggleEvent;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketRequestCheatPermission;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.NetworkManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldConfig
implements IWorldConfig,
IFilterTextSource {
    private static final Logger LOGGER = LogManager.getLogger();
    private final WorldConfigValues defaultValues = new WorldConfigValues();
    private final WorldConfigValues values = new WorldConfigValues();
    private final Configuration worldConfig;

    public WorldConfig(File jeiConfigurationDir) {
        File worldConfigFile = new File(jeiConfigurationDir, "worldSettings.cfg");
        this.worldConfig = new Configuration(worldConfigFile);
    }

    @Override
    public String getFilterText() {
        return this.values.filterText;
    }

    @Override
    public boolean setFilterText(String filterText) {
        if (this.values.filterText.equals(filterText)) {
            return false;
        }
        this.values.filterText = filterText;
        return true;
    }

    @Override
    public void saveFilterText() {
        NetHandlerPlayClient connection = Minecraft.func_71410_x().func_147114_u();
        if (connection != null) {
            NetworkManager networkManager = connection.func_147298_b();
            String worldCategory = ServerInfo.getWorldUid(networkManager);
            Property property = this.worldConfig.get(worldCategory, "filterText", this.defaultValues.filterText);
            property.set(this.values.filterText);
            if (this.worldConfig.hasChanged()) {
                // empty if block
            }
        }
    }

    @Override
    public boolean isOverlayEnabled() {
        return this.values.overlayEnabled || KeyBindings.toggleOverlay.getKey().func_197937_c() == -1;
    }

    @Override
    public void toggleOverlayEnabled() {
        this.values.overlayEnabled = !this.values.overlayEnabled;
        NetHandlerPlayClient connection = Minecraft.func_71410_x().func_147114_u();
        if (connection != null) {
            NetworkManager networkManager = connection.func_147298_b();
            String worldCategory = ServerInfo.getWorldUid(networkManager);
            Property property = this.worldConfig.get(worldCategory, "overlayEnabled", this.defaultValues.overlayEnabled);
            property.set(this.values.overlayEnabled);
            if (this.worldConfig.hasChanged()) {
                // empty if block
            }
        }
        EventBusHelper.post(new OverlayToggleEvent(this.values.overlayEnabled));
    }

    @Override
    public boolean isBookmarkOverlayEnabled() {
        return this.isOverlayEnabled() && this.values.bookmarkOverlayEnabled;
    }

    @Override
    public void toggleBookmarkEnabled() {
        this.setBookmarkEnabled(!this.values.bookmarkOverlayEnabled);
    }

    @Override
    public void setBookmarkEnabled(boolean value) {
        if (this.values.bookmarkOverlayEnabled != value) {
            this.values.bookmarkOverlayEnabled = value;
            NetHandlerPlayClient connection = Minecraft.func_71410_x().func_147114_u();
            if (connection != null) {
                NetworkManager networkManager = connection.func_147298_b();
                String worldCategory = ServerInfo.getWorldUid(networkManager);
                Property property = this.worldConfig.get(worldCategory, "bookmarkOverlayEnabled", this.defaultValues.bookmarkOverlayEnabled);
                property.set(this.values.bookmarkOverlayEnabled);
                if (this.worldConfig.hasChanged()) {
                    // empty if block
                }
            }
            EventBusHelper.post(new BookmarkOverlayToggleEvent(this.values.bookmarkOverlayEnabled));
        }
    }

    @Override
    public boolean isCheatItemsEnabled() {
        return this.values.cheatItemsEnabled;
    }

    @Override
    public boolean isDeleteItemsInCheatModeActive() {
        return this.values.cheatItemsEnabled && ServerInfo.isJeiOnServer();
    }

    @Override
    public void toggleCheatItemsEnabled() {
        this.setCheatItemsEnabled(!this.values.cheatItemsEnabled);
    }

    @Override
    public void setCheatItemsEnabled(boolean value) {
        if (this.values.cheatItemsEnabled != value) {
            this.values.cheatItemsEnabled = value;
            NetHandlerPlayClient connection = Minecraft.func_71410_x().func_147114_u();
            if (connection != null) {
                NetworkManager networkManager = connection.func_147298_b();
                String worldCategory = ServerInfo.getWorldUid(networkManager);
                Property property = this.worldConfig.get(worldCategory, "cheatItemsEnabled", this.defaultValues.cheatItemsEnabled);
                property.set(this.values.cheatItemsEnabled);
                if (this.worldConfig.hasChanged()) {
                    // empty if block
                }
            }
            if (this.values.cheatItemsEnabled && ServerInfo.isJeiOnServer()) {
                Network.sendPacketToServer(new PacketRequestCheatPermission());
            }
        }
    }

    @Override
    public boolean isHideModeEnabled() {
        return this.values.hideModeEnabled;
    }

    public void onWorldSave() {
        try {
            this.saveFilterText();
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to save filter text.", (Throwable)e);
        }
    }

    public boolean syncConfig() {
        NetHandlerPlayClient connection = Minecraft.func_71410_x().func_147114_u();
        if (connection != null) {
            NetworkManager networkManager = connection.func_147298_b();
            return this.syncWorldConfig(networkManager);
        }
        return false;
    }

    public boolean syncWorldConfig(@Nullable NetworkManager networkManager) {
        String worldCategory = ServerInfo.getWorldUid(networkManager);
        Property property = this.worldConfig.get(worldCategory, "overlayEnabled", this.defaultValues.overlayEnabled);
        property.setLanguageKey("config.jei.interface.overlayEnabled");
        property.setComment(Translator.translateToLocal("config.jei.interface.overlayEnabled.comment"));
        property.setShowInGui(false);
        this.values.overlayEnabled = property.getBoolean();
        property = this.worldConfig.get(worldCategory, "cheatItemsEnabled", this.defaultValues.cheatItemsEnabled);
        property.setLanguageKey("config.jei.mode.cheatItemsEnabled");
        property.setComment(Translator.translateToLocal("config.jei.mode.cheatItemsEnabled.comment"));
        this.values.cheatItemsEnabled = property.getBoolean();
        property = this.worldConfig.get(worldCategory, "editEnabled", this.defaultValues.hideModeEnabled);
        property.setLanguageKey("config.jei.mode.editEnabled");
        property.setComment(Translator.translateToLocal("config.jei.mode.editEnabled.comment"));
        this.values.hideModeEnabled = property.getBoolean();
        if (property.hasChanged()) {
            EventBusHelper.post(new EditModeToggleEvent(this.values.hideModeEnabled));
        }
        property = this.worldConfig.get(worldCategory, "bookmarkOverlayEnabled", this.defaultValues.bookmarkOverlayEnabled);
        property.setLanguageKey("config.jei.interface.bookmarkOverlayEnabled");
        property.setComment(Translator.translateToLocal("config.jei.interface.bookmarkOverlayEnabled.comment"));
        property.setShowInGui(false);
        this.values.bookmarkOverlayEnabled = property.getBoolean();
        property = this.worldConfig.get(worldCategory, "filterText", this.defaultValues.filterText);
        property.setShowInGui(false);
        this.values.filterText = property.getString();
        boolean configChanged = this.worldConfig.hasChanged();
        if (configChanged) {
            // empty if block
        }
        return false;
    }
}

