/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.config.IHideModeConfig;
import mezz.jei.config.IngredientBlacklistType;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientFilter;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HideModeConfig
implements IHideModeConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean defaultHideModeEnabled = false;
    private static final String[] defaultBlacklist = new String[0];
    private boolean hideModeEnabled = false;
    private final Set<String> blacklist = new LinkedHashSet<String>();
    @Nullable
    private final File blacklistConfigFile;

    public HideModeConfig(@Nullable File jeiConfigurationDir) {
        Collections.addAll(this.blacklist, defaultBlacklist);
        if (jeiConfigurationDir != null) {
            this.blacklistConfigFile = new File(jeiConfigurationDir, "blacklist.cfg");
            this.loadBlacklistConfig();
        } else {
            this.blacklistConfigFile = null;
        }
    }

    @Override
    public boolean isHideModeEnabled() {
        return this.hideModeEnabled;
    }

    private void loadBlacklistConfig() {
        if (this.blacklistConfigFile != null && this.blacklistConfigFile.exists()) {
            try (FileReader reader = new FileReader(this.blacklistConfigFile);){
                List strings = IOUtils.readLines((Reader)reader);
                this.blacklist.clear();
                this.blacklist.addAll(strings);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load blacklist from file {}", (Object)this.blacklistConfigFile, (Object)e);
            }
        }
    }

    private void saveBlacklist() {
        if (this.blacklistConfigFile != null) {
            try {
                if (this.blacklistConfigFile.createNewFile()) {
                    LOGGER.debug("Created blacklist config file: {}", (Object)this.blacklistConfigFile);
                }
                try (FileWriter writer = new FileWriter(this.blacklistConfigFile);){
                    IOUtils.writeLines(this.blacklist, (String)"\n", (Writer)writer);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to save blacklist to file {}", (Object)this.blacklistConfigFile, (Object)e);
            }
        }
    }

    @Override
    public <V> void addIngredientToConfigBlacklist(IngredientFilter ingredientFilter, IIngredientManager ingredientManager, V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        if (blacklistType == IngredientBlacklistType.ITEM) {
            String uid = HideModeConfig.getIngredientUid(ingredient, IngredientBlacklistType.ITEM, ingredientHelper);
            List<IIngredientListElement<V>> elementsToBeBlacklisted = ingredientFilter.getMatches(ingredient, ingredientHelper, input -> HideModeConfig.getIngredientUid(input, IngredientBlacklistType.WILDCARD, ingredientHelper));
            if (this.areAllBlacklisted(elementsToBeBlacklisted, ingredientHelper, uid)) {
                if (this.addIngredientToConfigBlacklist(ingredientFilter, ingredient, IngredientBlacklistType.WILDCARD, ingredientHelper)) {
                    this.saveBlacklist();
                }
                return;
            }
        }
        if (this.addIngredientToConfigBlacklist(ingredientFilter, ingredient, blacklistType, ingredientHelper)) {
            this.saveBlacklist();
        }
    }

    private <V> boolean addIngredientToConfigBlacklist(IngredientFilter ingredientFilter, V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        boolean updated = false;
        if (blacklistType == IngredientBlacklistType.WILDCARD) {
            List<IIngredientListElement<Object>> elementsToBeBlacklisted = ingredientFilter.getMatches(ingredient, ingredientHelper, input -> HideModeConfig.getIngredientUid(input, blacklistType, ingredientHelper));
            for (IIngredientListElement<Object> elementToBeBlacklisted : elementsToBeBlacklisted) {
                Object ingredientToBeBlacklisted = elementToBeBlacklisted.getIngredient();
                String uid = HideModeConfig.getIngredientUid(ingredientToBeBlacklisted, IngredientBlacklistType.ITEM, ingredientHelper);
                updated |= this.blacklist.remove(uid);
            }
        }
        String uid = HideModeConfig.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        return updated |= this.blacklist.add(uid);
    }

    private <V> boolean areAllBlacklisted(List<IIngredientListElement<V>> elements, IIngredientHelper<V> ingredientHelper, String newUid) {
        for (IIngredientListElement<V> element : elements) {
            V ingredient = element.getIngredient();
            String uid = HideModeConfig.getIngredientUid(ingredient, IngredientBlacklistType.ITEM, ingredientHelper);
            if (uid.equals(newUid) || this.blacklist.contains(uid)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <V> void removeIngredientFromConfigBlacklist(IngredientFilter ingredientFilter, IIngredientManager ingredientManager, V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid;
        boolean updated = false;
        if (blacklistType == IngredientBlacklistType.ITEM) {
            String wildUid = HideModeConfig.getIngredientUid(ingredient, IngredientBlacklistType.WILDCARD, ingredientHelper);
            if (this.blacklist.contains(wildUid)) {
                updated = true;
                this.blacklist.remove(wildUid);
                List<IIngredientListElement<Object>> modMatches = ingredientFilter.getMatches(ingredient, ingredientHelper, input -> HideModeConfig.getIngredientUid(input, IngredientBlacklistType.WILDCARD, ingredientHelper));
                for (IIngredientListElement<Object> modMatch : modMatches) {
                    this.addIngredientToConfigBlacklist(ingredientFilter, modMatch.getIngredient(), IngredientBlacklistType.ITEM, ingredientHelper);
                }
            }
        } else if (blacklistType == IngredientBlacklistType.WILDCARD) {
            List<IIngredientListElement<Object>> modMatches = ingredientFilter.getMatches(ingredient, ingredientHelper, input -> HideModeConfig.getIngredientUid(input, IngredientBlacklistType.WILDCARD, ingredientHelper));
            for (IIngredientListElement<Object> modMatch : modMatches) {
                Object matchIngredient = modMatch.getIngredient();
                String uid2 = HideModeConfig.getIngredientUid(matchIngredient, IngredientBlacklistType.ITEM, ingredientHelper);
                updated |= this.blacklist.remove(uid2);
            }
        }
        if (updated |= this.blacklist.remove(uid = HideModeConfig.getIngredientUid(ingredient, blacklistType, ingredientHelper))) {
            this.saveBlacklist();
        }
    }

    @Override
    public <V> boolean isIngredientOnConfigBlacklist(V ingredient, IIngredientHelper<V> ingredientHelper) {
        for (IngredientBlacklistType ingredientBlacklistType : IngredientBlacklistType.VALUES) {
            if (!this.isIngredientOnConfigBlacklist(ingredient, ingredientBlacklistType, ingredientHelper)) continue;
            return true;
        }
        return false;
    }

    public <V> boolean isIngredientOnConfigBlacklist(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = HideModeConfig.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        return this.blacklist.contains(uid);
    }

    private static <V> String getIngredientUid(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        switch (blacklistType) {
            case ITEM: {
                return ingredientHelper.getUniqueId(ingredient);
            }
            case WILDCARD: {
                return ingredientHelper.getWildcardId(ingredient);
            }
        }
        throw new IllegalStateException("Unknown blacklist type: " + (Object)((Object)blacklistType));
    }
}

