/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.v2.common.event.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.function.Consumer;
import journeymap.api.v2.common.event.impl.Event;

public class EventImpl<E>
implements Event<E> {
    private final Class<E> clazz;
    private final List<Listener<E>> listeners = new ArrayList<Listener<E>>();

    public EventImpl(Class<E> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void subscribe(String modId, Consumer<E> listener) {
        this.listeners.add(new Listener<E>(modId, listener));
    }

    @Override
    public void subscribe(Object subscriber, String modId, Consumer<E> listener) {
        this.listeners.add(new Listener<E>(modId, listener, subscriber.getClass()));
    }

    @Override
    public void unsubscribe(Object subscriber, String modId) throws ConcurrentModificationException {
        this.listeners.removeIf(listener -> subscriber.getClass().equals(listener.subscribingClass()) && modId.equals(listener.modId()));
    }

    public Class<E> getEventClass() {
        return this.clazz;
    }

    public List<Listener<E>> getListeners() {
        return this.listeners;
    }

    public record Listener<T>(String modId, Consumer<T> listener, Class<?> subscribingClass) {
        public Listener(String modId, Consumer<T> listener) {
            this(modId, listener, null);
        }
    }
}

