/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.v2.client.event;

import journeymap.api.v2.client.event.ClientEvent;
import journeymap.api.v2.client.fullscreen.IFullscreen;
import journeymap.api.v2.client.fullscreen.ModPopupMenu;
import journeymap.api.v2.common.waypoint.Waypoint;

public class PopupMenuEvent
extends ClientEvent {
    private final ModPopupMenu popupMenu;
    private final Layer layer;
    private final IFullscreen fullscreen;

    public PopupMenuEvent(ModPopupMenu popupMenu, Layer layer, IFullscreen fullscreen) {
        super(true);
        this.popupMenu = popupMenu;
        this.layer = layer;
        this.fullscreen = fullscreen;
    }

    public ModPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public IFullscreen getFullscreen() {
        return this.fullscreen;
    }

    public static enum Layer {
        WAYPOINT,
        FULLSCREEN;

    }

    public static class WaypointPopupMenuEvent
    extends PopupMenuEvent {
        private final Waypoint waypoint;

        public WaypointPopupMenuEvent(ModPopupMenu popupMenu, IFullscreen fullscreen, Waypoint waypoint) {
            super(popupMenu, Layer.WAYPOINT, fullscreen);
            this.waypoint = waypoint;
        }

        public Waypoint getWaypoint() {
            return this.waypoint;
        }
    }

    public static class FullscreenPopupMenuEvent
    extends PopupMenuEvent {
        public FullscreenPopupMenuEvent(ModPopupMenu popupMenu, IFullscreen fullscreen) {
            super(popupMenu, Layer.FULLSCREEN, fullscreen);
        }
    }
}

