/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.v2.client.ui.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class LayeredScreen
extends Screen {
    protected Minecraft minecraft = Minecraft.getInstance();
    protected Screen backgroundScreen;

    protected LayeredScreen(Component component) {
        super(component);
    }

    public void display() {
        if (this.minecraft.screen != null) {
            this.backgroundScreen = this.minecraft.screen;
        }
        this.minecraft.screen = this;
        this.added();
        this.init(this.minecraft, this.minecraft.getWindow().getGuiScaledWidth(), this.minecraft.getWindow().getGuiScaledHeight());
        this.minecraft.getNarrator().sayNow(this.getNarrationMessage());
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        if (this.backgroundScreen != null) {
            this.backgroundScreen.resize(this.minecraft, this.width, this.height);
        }
    }

    @Deprecated
    public final void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.backgroundScreen != null) {
            this.backgroundScreen.render(graphics, -1, -1, partialTicks);
        }
        graphics.pose().translate(0.0, 0.0, 2000.0);
        this.renderPopupScreenBackground(graphics, mouseX, mouseY, partialTicks);
        this.renderPopupScreen(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderPopupScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderPopupScreenBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public final void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void onClose() {
        this.popLayer();
    }

    public void popLayer() {
        if (this.minecraft.screen != null) {
            this.minecraft.screen.removed();
        }
        if (this.backgroundScreen != null) {
            this.minecraft.screen = this.backgroundScreen;
        } else {
            this.minecraft.setScreen(null);
        }
    }

    public Screen getBackgroundScreen() {
        return this.backgroundScreen;
    }
}

