/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.v2.client.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import journeymap.api.v2.common.event.impl.ClientEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.ApiStatus;

public class EntityRegistrationEvent
extends ClientEvent {
    private final Map<Type, List<Class<? extends Entity>>> entityClasses = new HashMap<Type, List<Class<? extends Entity>>>();

    public EntityRegistrationEvent(Map<Type, List<Class<? extends Entity>>> entityClasses) {
        super(false);
    }

    public EntityRegistrationEvent addPassiveEntity(Class<? extends LivingEntity> entityClass) {
        this.entityClasses.computeIfAbsent(Type.PASSIVE, p -> new ArrayList()).add(entityClass);
        return this;
    }

    public EntityRegistrationEvent addHostileEntity(Class<? extends LivingEntity> entityClass) {
        this.entityClasses.computeIfAbsent(Type.HOSTILE, h -> new ArrayList()).add(entityClass);
        return this;
    }

    public EntityRegistrationEvent addVillagerEntity(Class<? extends LivingEntity> entityClass) {
        this.entityClasses.computeIfAbsent(Type.VILLAGER, v -> new ArrayList()).add(entityClass);
        return this;
    }

    public EntityRegistrationEvent addAmbientEntity(Class<? extends LivingEntity> entityClass) {
        this.entityClasses.computeIfAbsent(Type.AMBIENT, a -> new ArrayList()).add(entityClass);
        return this;
    }

    private EntityRegistrationEvent addEntity(Class<? extends Entity> entityClass) {
        if (entityClass.isAssignableFrom(LivingEntity.class)) {
            throw new UnsupportedOperationException("Attempted to register LivingEntity as a NonLivingEntity");
        }
        this.entityClasses.computeIfAbsent(Type.ENTITY, e -> new ArrayList()).add(entityClass);
        return this;
    }

    @ApiStatus.Internal
    public List<Class<? extends Entity>> getEntityClasses(Type type) {
        return Collections.unmodifiableList(this.entityClasses.get((Object)type));
    }

    public static enum Type {
        PASSIVE,
        HOSTILE,
        VILLAGER,
        AMBIENT,
        ENTITY;

    }
}

