/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.v2.common.waypoint;

import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WaypointFactory {
    private final WaypointStore store;
    private static WaypointFactory INSTANCE;

    @ApiStatus.Internal
    public WaypointFactory(WaypointStore store) {
        this.store = store;
        INSTANCE = this;
    }

    private static WaypointFactory getInstance() {
        return INSTANCE;
    }

    public static Waypoint createClientWaypoint(String modId, BlockPos pos, @Nullable String name, ResourceKey<Level> primaryDimension, boolean persistent) {
        return WaypointFactory.createClientWaypoint(modId, pos, name, primaryDimension.location().toString(), persistent);
    }

    public static Waypoint createClientWaypoint(String modId, BlockPos pos, ResourceKey<Level> primaryDimension, boolean persistent) {
        return WaypointFactory.createClientWaypoint(modId, pos, primaryDimension.location().toString(), persistent);
    }

    public static Waypoint createClientWaypoint(String modId, BlockPos pos, String primaryDimension, boolean persistent) {
        return WaypointFactory.createClientWaypoint(modId, pos, null, primaryDimension, persistent);
    }

    public static Waypoint createClientWaypoint(String modId, BlockPos pos, @Nullable String name, String primaryDimension, boolean persistent) {
        return WaypointFactory.getInstance().store.createClientWaypoint(modId, pos, name, primaryDimension, persistent);
    }

    public static WaypointGroup createWaypointGroup(String modId, String name) {
        return WaypointFactory.getInstance().store.createWaypointGroup(modId, name);
    }

    @ApiStatus.Internal
    public static interface WaypointStore {
        public Waypoint createClientWaypoint(String var1, BlockPos var2, @Nullable String var3, String var4, boolean var5);

        public WaypointGroup createWaypointGroup(String var1, String var2);
    }
}

