/*
 * JourneyMap API (http://journeymap.info)
 * http://github.com/TeamJM/journeymap-api
 *
 * Copyright (c) 2011-2016 Techbrew.  All Rights Reserved.
 * The following limited rights are granted to you:
 *
 * You MAY:
 *  + Write your own code that uses the API source code in journeymap.* packages as a dependency.
 *  + Write and distribute your own code that uses, modifies, or extends the example source code in example.* packages
 *  + Fork and modify any source code for the purpose of submitting Pull Requests to the TeamJM/journeymap-api repository.
 *    Submitting new or modified code to the repository means that you are granting Techbrew all rights to the submitted code.
 *
 * You MAY NOT:
 *  - Distribute source code or classes (whether modified or not) from journeymap.* packages.
 *  - Submit any code to the TeamJM/journeymap-api repository with a different license than this one.
 *  - Use code or artifacts from the repository in any way not explicitly granted by this license.
 *
 */

package journeymap.api.v2.client.event;

import journeymap.api.v2.common.event.impl.JourneyMapEvent;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

/**
 * Parent class for events propagated by the Client API to IClientPlugin implementations.
 */
public abstract class ClientEvent extends JourneyMapEvent
{

    /**
     * World dimension where event occurred.
     */
    public final class_5321<class_1937> dimension;

    /**
     * Constructor.
     */
    public ClientEvent(boolean cancellable, class_5321<class_1937> dimension)
    {
        super(cancellable);
        this.dimension = dimension;
    }

    /**
     * Constructor.
     */
    public ClientEvent(boolean cancellable)
    {
        this(cancellable, class_1937.field_25179);
    }
}
