package journeymap.api.v2.common.waypoint;

import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.TreeSet;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public interface Waypoint
{
    /**
     * Non-unique id that is a comibination of modId and waypoint position.
     */
    String getId();

    /**
     * Unique Id for each waypoint, will not change.
     */
    String getGuid();

    /**
     * Unique id of the group this waypoint belongs to.
     */
    String getGroupId();

    String getModId();

    String getName();

    void setName(String name);

    void setPos(int x, int y, int z);

    void setBlockPos(class_2338 pos);

    class_2338 getBlockPos();

    int getX();

    void setX(int x);

    int getY();

    void setY(int y);

    int getZ();

    void setZ(int z);

    int getRed();

    void setRed(int red);

    int getGreen();

    void setGreen(int green);

    int getBlue();

    void setBlue(int blue);

    int getColor();

    void setColor(int color);

    TreeSet<String> getDimensions();

    void setDimensions(Collection<String> dims);

    default void setPrimaryDimension(class_5321<class_1937> dimension)
    {
        setPrimaryDimension(dimension.method_29177().toString());
    }

    void setPrimaryDimension(String dimension);

    String getPrimaryDimension();

    boolean isPersistent();

    void setPersistent(boolean persistent);


    /**
     * Is waypoint enabled.
     *
     * @return - the Enabled boolean
     */
    boolean isEnabled();

    /**
     * Set waypoint enabled / disabled
     *
     * @param enabled - enabled
     */
    void setEnabled(boolean enabled);

    /**
     * Is deviation being shown
     *
     * @return - is showing
     */
    boolean showDeviation();

    /**
     * Sets the show deviation text on the beacon.
     *
     * @param showDeviation - the boolean
     */
    void setShowDeviation(boolean showDeviation);

    // ############ ICON ############
    /*
     * These values do not need to be set if using the default icon.
     * If using a custom image for your icon, setting the resource location is all that is needed.
     * Use the other values to fine tune image size, rotation, alpha, and color.
     * Setting the color will use a different color than the waypoint beacon color for the icon.
     *
     * All Icon setters are optional.
     */

    /**
     * Gets the rotation in degrees the image should be oriented.
     * Zero is the default.
     *
     * @return degrees
     */
    int getIconRotation();

    /**
     * Sets the rotation in degrees the image should be oriented.
     * Zero is the default.
     *
     * @param rotation in degrees
     */
    void setIconRotation(int rotation);

    /**
     * Gets color.
     *
     * @return the color
     */
    Integer getIconColor();

    /**
     * Sets color used to tint the image.  Use 0xffffff for no tint.
     * This is only to be used if the icon needs to have a separate color from the waypoint.
     * Defaults to -1 which will tint the icon to the beacon color.
     *
     * @param color the color
     */
    void setIconColor(Integer color);

    /**
     * Gets opacity.
     *
     * @return the opacity
     */
    float getIconOpacity();

    /**
     * Sets opacity.
     *
     * @param opacity the opacity
     */
    void setIconOpacity(float opacity);

    /**
     * Gets the texture resource location.
     *
     * @return - ResourceLocation
     */
    class_2960 getIconResourceLocation();

    /**
     * Sets the texture resource location.
     *
     * @param resourceLocation - the resource location
     */
    void setIconResourceLoctaion(class_2960 resourceLocation);

    /**
     * Gets the image textureWidth.
     *
     * @return textureWidth
     */
    int getIconTextureWidth();

    /**
     * Sets the texture width
     *
     * @param width - the texture width
     */
    void setIconTextureWidth(Integer width);

    /**
     * Gets the image textureHeight.
     *
     * @return textureHeight
     */
    int getIconTextureHeight();

    /**
     * Sets the texture height
     *
     * @param height - the texture height
     */
    void setIconTextureHeight(Integer height);

    /**
     * Set the texture size
     *
     * @param width  - the texture width
     * @param height - the texture height
     */
    default void setIconTextureSize(int width, int height)
    {
        setIconTextureWidth(width);
        setIconTextureHeight(height);
    }

    /**
     * Allows add-on devs to set custom data on their waypoints for use, this is not used by journeymap.
     *
     * @param data - String
     */
    void setCustomData(@Nullable String data);

    /**
     * Gets the custom data stored on a waypoint
     * @return
     */
    @Nullable
    String getCustomData();
}
