/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.v2.client.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import journeymap.api.v2.common.event.impl.ClientEvent;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import org.jetbrains.annotations.ApiStatus;

public class EntityRegistrationEvent
extends ClientEvent {
    private final Map<Type, List<Class<? extends class_1297>>> entityClasses = new HashMap<Type, List<Class<? extends class_1297>>>();

    public EntityRegistrationEvent(Map<Type, List<Class<? extends class_1297>>> entityClasses) {
        super(false);
    }

    public EntityRegistrationEvent addPassiveEntity(Class<? extends class_1309> entityClass) {
        this.entityClasses.computeIfAbsent(Type.PASSIVE, p -> new ArrayList()).add(entityClass);
        return this;
    }

    public EntityRegistrationEvent addHostileEntity(Class<? extends class_1309> entityClass) {
        this.entityClasses.computeIfAbsent(Type.HOSTILE, h -> new ArrayList()).add(entityClass);
        return this;
    }

    public EntityRegistrationEvent addVillagerEntity(Class<? extends class_1309> entityClass) {
        this.entityClasses.computeIfAbsent(Type.VILLAGER, v -> new ArrayList()).add(entityClass);
        return this;
    }

    public EntityRegistrationEvent addAmbientEntity(Class<? extends class_1309> entityClass) {
        this.entityClasses.computeIfAbsent(Type.AMBIENT, a -> new ArrayList()).add(entityClass);
        return this;
    }

    private EntityRegistrationEvent addEntity(Class<? extends class_1297> entityClass) {
        if (entityClass.isAssignableFrom(class_1309.class)) {
            throw new UnsupportedOperationException("Attempted to register LivingEntity as a NonLivingEntity");
        }
        this.entityClasses.computeIfAbsent(Type.ENTITY, e -> new ArrayList()).add(entityClass);
        return this;
    }

    @ApiStatus.Internal
    public List<Class<? extends class_1297>> getEntityClasses(Type type) {
        return Collections.unmodifiableList(this.entityClasses.get((Object)type));
    }

    public static enum Type {
        PASSIVE,
        HOSTILE,
        VILLAGER,
        AMBIENT,
        ENTITY;

    }
}

