package journeymap.api.v2.client.event;

import com.google.common.base.MoreObjects;
import journeymap.api.v2.common.event.impl.ClientEvent;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;

/**
 * Indicates a Death Waypoint is about to be created.
 * Can be cancelled, which will prevent the waypoint creation.
 */
public class DeathWaypointEvent extends ClientEvent
{
    public final class_2338 location;

    /**
     * Constructor.
     *
     * @param location  The location of the waypoint.
     * @param dimension The dimension of the waypoint.
     */
    public DeathWaypointEvent(class_2338 location, class_5321<class_1937> dimension)
    {
        super(true, dimension);
        this.location = location;
    }

    @Override
    public String toString()
    {
        return MoreObjects.toStringHelper(this)
                .add("location", location)
                .toString();
    }
}
