package journeymap.api.v2.client.event;

import journeymap.api.v2.common.event.impl.ClientEvent;
import net.minecraft.class_2561;
import java.util.function.Supplier;

/**
 * Event classes for journeymap registries.
 * This event is not cancellable.
 */
public class RegistryEvent extends ClientEvent
{
    private final RegistryType registryType;

    /**
     * Fired when it is time for addons to register things for Journeymap.
     *
     * @param registryType - The registry type.
     */
    private RegistryEvent(RegistryType registryType)
    {
        super(false);
        this.registryType = registryType;
    }

    /**
     * @return - The registry type.
     */
    public RegistryType getRegistryType()
    {
        return registryType;
    }

    /**
     * Fired when it is time to register custom options to display in journeymap options screen.
     * <p>
     * This event is fired very early during the mod loading process. It is fired at the postInit phase of Journeymap
     * which is right before the main title screen is loaded.
     */
    public static class OptionsRegistryEvent extends RegistryEvent
    {
        public OptionsRegistryEvent()
        {
            super(RegistryType.OPTIONS);
        }
    }

    /**
     * Used for creating your own info slots.
     * This event is fired before the {@link OptionsRegistryEvent} as the info slots are need for the configs.
     */
    public static class InfoSlotRegistryEvent extends RegistryEvent
    {
        private final InfoSlotRegistrar registrar;

        public InfoSlotRegistryEvent(InfoSlotRegistrar registrar)
        {
            super(RegistryType.INFO_SLOT);
            this.registrar = registrar;
        }

        /**
         * Registers an infoslot.
         * <p>
         * Please supply a key.tooltip in your lang files so that the dropdown item has a tool tip.
         *
         * @param modId      - The ModId
         * @param key        - The i18n key or Label for the InfoSlot dropdown in the options menu.
         * @param updateTime - How often in milliseconds to update.
         * @param supplier   - The supplier that gets the value to be displayed.
         */
        public void register(String modId, String key, long updateTime, Supplier<String> supplier)
        {
            registrar.register(modId, class_2561.method_43471(key), updateTime, () -> class_2561.method_43470(supplier.get()));
        }

        /**
         * Registers an infoslot.
         * <p>
         * Please supply a key.tooltip in your lang files so that the dropdown item has a tool tip.
         * <p>
         * For key please use Component.translateable("key") here will also only render as white and does not support param arguments at this time.
         * In the future, the dropdown will fully support Components and formatting.
         *
         * @param modId      - The ModId
         * @param key        - The i18n key for the InfoSlot dropdown in the options menu.
         * @param updateTime - How often in milliseconds to update.
         * @param supplier   - The supplier that gets the value to be displayed.
         */
        public void register(String modId, class_2561 key, long updateTime, Supplier<class_2561> supplier)
        {
            registrar.register(modId, key, updateTime, supplier);
        }

        public interface InfoSlotRegistrar
        {
            /**
             * Registers an infoslot.
             *
             * @param modId      - The ModId
             * @param component  - The i18n key or Label for the InfoSlot dropdown in the options menu.
             * @param updateTime - How often in milliseconds to update.
             * @param supplier   - The supplier that gets the value to be displayed.
             */
            void register(String modId, class_2561 component, long updateTime, Supplier<class_2561> supplier);
        }
    }


    /**
     * The registry types.
     */
    public enum RegistryType
    {
        OPTIONS,
        INFO_SLOT
    }
}
