package journeymap.api.v2.common.waypoint;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;


public class WaypointFactory
{
    private final WaypointStore store;

    private static WaypointFactory INSTANCE;

    @ApiStatus.Internal
    public WaypointFactory(WaypointStore store)
    {
        this.store = store;
        INSTANCE = this;
    }


    private static WaypointFactory getInstance()
    {
        return INSTANCE;
    }

    /**
     * Creates a ClientWaypoint.
     *
     * @param modId            - The modid of the mod creating the waypoint
     * @param pos              - The BlockPos of the waypoint
     * @param name             - The Optional Name of the waypoint. If null, it will use the coordinates as the name.e
     * @param primaryDimension - The primary dimension, this is where it will be displayed and if
     *                         waypoint teleporting is enabled this is the dimension the user will be teleported to.
     * @param persistent       - should the waypoint persist between sessions?
     *                         True, JourneyMap will save this waypoint to disk and load every session it only needs to be sent once.
     *                         False, The waypoint will be flushed when the user changes dimensions and exits the game.
     * @return - The Waypoint with default values set.
     */
    public static Waypoint createClientWaypoint(String modId, class_2338 pos, @Nullable String name, class_5321<class_1937> primaryDimension, boolean persistent)
    {
        return createClientWaypoint(modId, pos, name, primaryDimension.method_29177().toString(), persistent);
    }

    public static Waypoint createClientWaypoint(String modId, class_2338 pos, class_5321<class_1937> primaryDimension, boolean persistent)
    {
        return createClientWaypoint(modId, pos, primaryDimension.method_29177().toString(), persistent);
    }

    public static Waypoint createClientWaypoint(String modId, class_2338 pos, String primaryDimension, boolean persistent)
    {
        return createClientWaypoint(modId, pos, null, primaryDimension, persistent);
    }

    public static Waypoint createClientWaypoint(String modId, class_2338 pos, @Nullable String name, String primaryDimension, boolean persistent)
    {
        return getInstance().store.createClientWaypoint(modId, pos, name, primaryDimension, persistent);
    }

    public static Waypoint fromWaypointJsonString(String waypoint)
    {
        return getInstance().store.fromWaypointJsonString(waypoint);
    }

    public static WaypointGroup fromGroupJsonString(String waypoint)
    {
        return getInstance().store.fromGroupJsonString(waypoint);
    }

    public static WaypointGroup createWaypointGroup(String modId, String name)
    {
        return getInstance().store.createWaypointGroup(modId, name);
    }


    @ApiStatus.Internal
    public interface WaypointStore
    {
        Waypoint createClientWaypoint(String modId, class_2338 pos, @Nullable String name, String primaryDimension, boolean persistent);

        Waypoint fromWaypointJsonString(String waypoint);

        WaypointGroup fromGroupJsonString(String waypoint);

        WaypointGroup createWaypointGroup(String modId, String name);
    }
}
